<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiteDespatch StructType
 * @subpackage Structs
 */
class SiteDespatch extends AbstractStructBase
{
    /**
     * The Aerosol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Aerosol;
    /**
     * The Compensation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Compensation;
    /**
     * The Fragile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Fragile;
    /**
     * The Hazardous
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Hazardous;
    /**
     * The HouseholdSignature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $HouseholdSignature;
    /**
     * The Liquid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Liquid;
    /**
     * The MaxHeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxHeight;
    /**
     * The MaxItemWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxItemWeight;
    /**
     * The MaxLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxLength;
    /**
     * The MaxLengthSum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxLengthSum;
    /**
     * The MaxParcelWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxParcelWeight;
    /**
     * The MaxWidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxWidth;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OrderNumber;
    /**
     * The OrderValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OrderValue;
    /**
     * The OrderVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OrderVolume;
    /**
     * The OrderWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OrderWeight;
    /**
     * The PalletDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PalletDelivery;
    /**
     * The ProofOfDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ProofOfDelivery;
    /**
     * The TwoManLift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $TwoManLift;
    /**
     * The WeightOfHeaviest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $WeightOfHeaviest;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The AdditionalCompensation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AdditionalCompensation;
    /**
     * The SiteCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteCode;
    /**
     * The SiteDespatchProducts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSiteDespatchProduct
     */
    public $SiteDespatchProducts;
    /**
     * Constructor method for SiteDespatch
     * @uses SiteDespatch::setAerosol()
     * @uses SiteDespatch::setCompensation()
     * @uses SiteDespatch::setFragile()
     * @uses SiteDespatch::setHazardous()
     * @uses SiteDespatch::setHouseholdSignature()
     * @uses SiteDespatch::setLiquid()
     * @uses SiteDespatch::setMaxHeight()
     * @uses SiteDespatch::setMaxItemWeight()
     * @uses SiteDespatch::setMaxLength()
     * @uses SiteDespatch::setMaxLengthSum()
     * @uses SiteDespatch::setMaxParcelWeight()
     * @uses SiteDespatch::setMaxWidth()
     * @uses SiteDespatch::setOrderNumber()
     * @uses SiteDespatch::setOrderValue()
     * @uses SiteDespatch::setOrderVolume()
     * @uses SiteDespatch::setOrderWeight()
     * @uses SiteDespatch::setPalletDelivery()
     * @uses SiteDespatch::setProofOfDelivery()
     * @uses SiteDespatch::setTwoManLift()
     * @uses SiteDespatch::setWeightOfHeaviest()
     * @uses SiteDespatch::setExtensionData()
     * @uses SiteDespatch::setAdditionalCompensation()
     * @uses SiteDespatch::setSiteCode()
     * @uses SiteDespatch::setSiteDespatchProducts()
     * @param bool $aerosol
     * @param bool $compensation
     * @param bool $fragile
     * @param bool $hazardous
     * @param bool $householdSignature
     * @param bool $liquid
     * @param float $maxHeight
     * @param float $maxItemWeight
     * @param float $maxLength
     * @param float $maxLengthSum
     * @param float $maxParcelWeight
     * @param float $maxWidth
     * @param int $orderNumber
     * @param float $orderValue
     * @param float $orderVolume
     * @param float $orderWeight
     * @param bool $palletDelivery
     * @param bool $proofOfDelivery
     * @param bool $twoManLift
     * @param float $weightOfHeaviest
     * @param \StructType\ExtensionDataObject $extensionData
     * @param bool $additionalCompensation
     * @param string $siteCode
     * @param \ArrayType\ArrayOfSiteDespatchProduct $siteDespatchProducts
     */
    public function __construct($aerosol = null, $compensation = null, $fragile = null, $hazardous = null, $householdSignature = null, $liquid = null, $maxHeight = null, $maxItemWeight = null, $maxLength = null, $maxLengthSum = null, $maxParcelWeight = null, $maxWidth = null, $orderNumber = null, $orderValue = null, $orderVolume = null, $orderWeight = null, $palletDelivery = null, $proofOfDelivery = null, $twoManLift = null, $weightOfHeaviest = null, \StructType\ExtensionDataObject $extensionData = null, $additionalCompensation = null, $siteCode = null, \ArrayType\ArrayOfSiteDespatchProduct $siteDespatchProducts = null)
    {
        $this
            ->setAerosol($aerosol)
            ->setCompensation($compensation)
            ->setFragile($fragile)
            ->setHazardous($hazardous)
            ->setHouseholdSignature($householdSignature)
            ->setLiquid($liquid)
            ->setMaxHeight($maxHeight)
            ->setMaxItemWeight($maxItemWeight)
            ->setMaxLength($maxLength)
            ->setMaxLengthSum($maxLengthSum)
            ->setMaxParcelWeight($maxParcelWeight)
            ->setMaxWidth($maxWidth)
            ->setOrderNumber($orderNumber)
            ->setOrderValue($orderValue)
            ->setOrderVolume($orderVolume)
            ->setOrderWeight($orderWeight)
            ->setPalletDelivery($palletDelivery)
            ->setProofOfDelivery($proofOfDelivery)
            ->setTwoManLift($twoManLift)
            ->setWeightOfHeaviest($weightOfHeaviest)
            ->setExtensionData($extensionData)
            ->setAdditionalCompensation($additionalCompensation)
            ->setSiteCode($siteCode)
            ->setSiteDespatchProducts($siteDespatchProducts);
    }
    /**
     * Get Aerosol value
     * @return bool
     */
    public function getAerosol()
    {
        return $this->Aerosol;
    }
    /**
     * Set Aerosol value
     * @param bool $aerosol
     * @return \StructType\SiteDespatch
     */
    public function setAerosol($aerosol = null)
    {
        // validation for constraint: boolean
        if (!is_null($aerosol) && !is_bool($aerosol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aerosol, true), gettype($aerosol)), __LINE__);
        }
        $this->Aerosol = $aerosol;
        return $this;
    }
    /**
     * Get Compensation value
     * @return bool
     */
    public function getCompensation()
    {
        return $this->Compensation;
    }
    /**
     * Set Compensation value
     * @param bool $compensation
     * @return \StructType\SiteDespatch
     */
    public function setCompensation($compensation = null)
    {
        // validation for constraint: boolean
        if (!is_null($compensation) && !is_bool($compensation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compensation, true), gettype($compensation)), __LINE__);
        }
        $this->Compensation = $compensation;
        return $this;
    }
    /**
     * Get Fragile value
     * @return bool
     */
    public function getFragile()
    {
        return $this->Fragile;
    }
    /**
     * Set Fragile value
     * @param bool $fragile
     * @return \StructType\SiteDespatch
     */
    public function setFragile($fragile = null)
    {
        // validation for constraint: boolean
        if (!is_null($fragile) && !is_bool($fragile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fragile, true), gettype($fragile)), __LINE__);
        }
        $this->Fragile = $fragile;
        return $this;
    }
    /**
     * Get Hazardous value
     * @return bool
     */
    public function getHazardous()
    {
        return $this->Hazardous;
    }
    /**
     * Set Hazardous value
     * @param bool $hazardous
     * @return \StructType\SiteDespatch
     */
    public function setHazardous($hazardous = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardous) && !is_bool($hazardous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hazardous, true), gettype($hazardous)), __LINE__);
        }
        $this->Hazardous = $hazardous;
        return $this;
    }
    /**
     * Get HouseholdSignature value
     * @return bool
     */
    public function getHouseholdSignature()
    {
        return $this->HouseholdSignature;
    }
    /**
     * Set HouseholdSignature value
     * @param bool $householdSignature
     * @return \StructType\SiteDespatch
     */
    public function setHouseholdSignature($householdSignature = null)
    {
        // validation for constraint: boolean
        if (!is_null($householdSignature) && !is_bool($householdSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($householdSignature, true), gettype($householdSignature)), __LINE__);
        }
        $this->HouseholdSignature = $householdSignature;
        return $this;
    }
    /**
     * Get Liquid value
     * @return bool
     */
    public function getLiquid()
    {
        return $this->Liquid;
    }
    /**
     * Set Liquid value
     * @param bool $liquid
     * @return \StructType\SiteDespatch
     */
    public function setLiquid($liquid = null)
    {
        // validation for constraint: boolean
        if (!is_null($liquid) && !is_bool($liquid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($liquid, true), gettype($liquid)), __LINE__);
        }
        $this->Liquid = $liquid;
        return $this;
    }
    /**
     * Get MaxHeight value
     * @return float
     */
    public function getMaxHeight()
    {
        return $this->MaxHeight;
    }
    /**
     * Set MaxHeight value
     * @param float $maxHeight
     * @return \StructType\SiteDespatch
     */
    public function setMaxHeight($maxHeight = null)
    {
        // validation for constraint: float
        if (!is_null($maxHeight) && !(is_float($maxHeight) || is_numeric($maxHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxHeight, true), gettype($maxHeight)), __LINE__);
        }
        $this->MaxHeight = $maxHeight;
        return $this;
    }
    /**
     * Get MaxItemWeight value
     * @return float
     */
    public function getMaxItemWeight()
    {
        return $this->MaxItemWeight;
    }
    /**
     * Set MaxItemWeight value
     * @param float $maxItemWeight
     * @return \StructType\SiteDespatch
     */
    public function setMaxItemWeight($maxItemWeight = null)
    {
        // validation for constraint: float
        if (!is_null($maxItemWeight) && !(is_float($maxItemWeight) || is_numeric($maxItemWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxItemWeight, true), gettype($maxItemWeight)), __LINE__);
        }
        $this->MaxItemWeight = $maxItemWeight;
        return $this;
    }
    /**
     * Get MaxLength value
     * @return float
     */
    public function getMaxLength()
    {
        return $this->MaxLength;
    }
    /**
     * Set MaxLength value
     * @param float $maxLength
     * @return \StructType\SiteDespatch
     */
    public function setMaxLength($maxLength = null)
    {
        // validation for constraint: float
        if (!is_null($maxLength) && !(is_float($maxLength) || is_numeric($maxLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxLength, true), gettype($maxLength)), __LINE__);
        }
        $this->MaxLength = $maxLength;
        return $this;
    }
    /**
     * Get MaxLengthSum value
     * @return float
     */
    public function getMaxLengthSum()
    {
        return $this->MaxLengthSum;
    }
    /**
     * Set MaxLengthSum value
     * @param float $maxLengthSum
     * @return \StructType\SiteDespatch
     */
    public function setMaxLengthSum($maxLengthSum = null)
    {
        // validation for constraint: float
        if (!is_null($maxLengthSum) && !(is_float($maxLengthSum) || is_numeric($maxLengthSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxLengthSum, true), gettype($maxLengthSum)), __LINE__);
        }
        $this->MaxLengthSum = $maxLengthSum;
        return $this;
    }
    /**
     * Get MaxParcelWeight value
     * @return float
     */
    public function getMaxParcelWeight()
    {
        return $this->MaxParcelWeight;
    }
    /**
     * Set MaxParcelWeight value
     * @param float $maxParcelWeight
     * @return \StructType\SiteDespatch
     */
    public function setMaxParcelWeight($maxParcelWeight = null)
    {
        // validation for constraint: float
        if (!is_null($maxParcelWeight) && !(is_float($maxParcelWeight) || is_numeric($maxParcelWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxParcelWeight, true), gettype($maxParcelWeight)), __LINE__);
        }
        $this->MaxParcelWeight = $maxParcelWeight;
        return $this;
    }
    /**
     * Get MaxWidth value
     * @return float
     */
    public function getMaxWidth()
    {
        return $this->MaxWidth;
    }
    /**
     * Set MaxWidth value
     * @param float $maxWidth
     * @return \StructType\SiteDespatch
     */
    public function setMaxWidth($maxWidth = null)
    {
        // validation for constraint: float
        if (!is_null($maxWidth) && !(is_float($maxWidth) || is_numeric($maxWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxWidth, true), gettype($maxWidth)), __LINE__);
        }
        $this->MaxWidth = $maxWidth;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return int
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param int $orderNumber
     * @return \StructType\SiteDespatch
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: int
        if (!is_null($orderNumber) && !(is_int($orderNumber) || ctype_digit($orderNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get OrderValue value
     * @return float
     */
    public function getOrderValue()
    {
        return $this->OrderValue;
    }
    /**
     * Set OrderValue value
     * @param float $orderValue
     * @return \StructType\SiteDespatch
     */
    public function setOrderValue($orderValue = null)
    {
        // validation for constraint: float
        if (!is_null($orderValue) && !(is_float($orderValue) || is_numeric($orderValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderValue, true), gettype($orderValue)), __LINE__);
        }
        $this->OrderValue = $orderValue;
        return $this;
    }
    /**
     * Get OrderVolume value
     * @return float
     */
    public function getOrderVolume()
    {
        return $this->OrderVolume;
    }
    /**
     * Set OrderVolume value
     * @param float $orderVolume
     * @return \StructType\SiteDespatch
     */
    public function setOrderVolume($orderVolume = null)
    {
        // validation for constraint: float
        if (!is_null($orderVolume) && !(is_float($orderVolume) || is_numeric($orderVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderVolume, true), gettype($orderVolume)), __LINE__);
        }
        $this->OrderVolume = $orderVolume;
        return $this;
    }
    /**
     * Get OrderWeight value
     * @return float
     */
    public function getOrderWeight()
    {
        return $this->OrderWeight;
    }
    /**
     * Set OrderWeight value
     * @param float $orderWeight
     * @return \StructType\SiteDespatch
     */
    public function setOrderWeight($orderWeight = null)
    {
        // validation for constraint: float
        if (!is_null($orderWeight) && !(is_float($orderWeight) || is_numeric($orderWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderWeight, true), gettype($orderWeight)), __LINE__);
        }
        $this->OrderWeight = $orderWeight;
        return $this;
    }
    /**
     * Get PalletDelivery value
     * @return bool
     */
    public function getPalletDelivery()
    {
        return $this->PalletDelivery;
    }
    /**
     * Set PalletDelivery value
     * @param bool $palletDelivery
     * @return \StructType\SiteDespatch
     */
    public function setPalletDelivery($palletDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($palletDelivery) && !is_bool($palletDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($palletDelivery, true), gettype($palletDelivery)), __LINE__);
        }
        $this->PalletDelivery = $palletDelivery;
        return $this;
    }
    /**
     * Get ProofOfDelivery value
     * @return bool
     */
    public function getProofOfDelivery()
    {
        return $this->ProofOfDelivery;
    }
    /**
     * Set ProofOfDelivery value
     * @param bool $proofOfDelivery
     * @return \StructType\SiteDespatch
     */
    public function setProofOfDelivery($proofOfDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($proofOfDelivery) && !is_bool($proofOfDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($proofOfDelivery, true), gettype($proofOfDelivery)), __LINE__);
        }
        $this->ProofOfDelivery = $proofOfDelivery;
        return $this;
    }
    /**
     * Get TwoManLift value
     * @return bool
     */
    public function getTwoManLift()
    {
        return $this->TwoManLift;
    }
    /**
     * Set TwoManLift value
     * @param bool $twoManLift
     * @return \StructType\SiteDespatch
     */
    public function setTwoManLift($twoManLift = null)
    {
        // validation for constraint: boolean
        if (!is_null($twoManLift) && !is_bool($twoManLift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($twoManLift, true), gettype($twoManLift)), __LINE__);
        }
        $this->TwoManLift = $twoManLift;
        return $this;
    }
    /**
     * Get WeightOfHeaviest value
     * @return float
     */
    public function getWeightOfHeaviest()
    {
        return $this->WeightOfHeaviest;
    }
    /**
     * Set WeightOfHeaviest value
     * @param float $weightOfHeaviest
     * @return \StructType\SiteDespatch
     */
    public function setWeightOfHeaviest($weightOfHeaviest = null)
    {
        // validation for constraint: float
        if (!is_null($weightOfHeaviest) && !(is_float($weightOfHeaviest) || is_numeric($weightOfHeaviest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weightOfHeaviest, true), gettype($weightOfHeaviest)), __LINE__);
        }
        $this->WeightOfHeaviest = $weightOfHeaviest;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\SiteDespatch
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get AdditionalCompensation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAdditionalCompensation()
    {
        return isset($this->AdditionalCompensation) ? $this->AdditionalCompensation : null;
    }
    /**
     * Set AdditionalCompensation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $additionalCompensation
     * @return \StructType\SiteDespatch
     */
    public function setAdditionalCompensation($additionalCompensation = null)
    {
        // validation for constraint: boolean
        if (!is_null($additionalCompensation) && !is_bool($additionalCompensation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($additionalCompensation, true), gettype($additionalCompensation)), __LINE__);
        }
        if (is_null($additionalCompensation) || (is_array($additionalCompensation) && empty($additionalCompensation))) {
            unset($this->AdditionalCompensation);
        } else {
            $this->AdditionalCompensation = $additionalCompensation;
        }
        return $this;
    }
    /**
     * Get SiteCode value
     * @return string|null
     */
    public function getSiteCode()
    {
        return $this->SiteCode;
    }
    /**
     * Set SiteCode value
     * @param string $siteCode
     * @return \StructType\SiteDespatch
     */
    public function setSiteCode($siteCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCode) && !is_string($siteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCode, true), gettype($siteCode)), __LINE__);
        }
        $this->SiteCode = $siteCode;
        return $this;
    }
    /**
     * Get SiteDespatchProducts value
     * @return \ArrayType\ArrayOfSiteDespatchProduct|null
     */
    public function getSiteDespatchProducts()
    {
        return $this->SiteDespatchProducts;
    }
    /**
     * Set SiteDespatchProducts value
     * @param \ArrayType\ArrayOfSiteDespatchProduct $siteDespatchProducts
     * @return \StructType\SiteDespatch
     */
    public function setSiteDespatchProducts(\ArrayType\ArrayOfSiteDespatchProduct $siteDespatchProducts = null)
    {
        $this->SiteDespatchProducts = $siteDespatchProducts;
        return $this;
    }
}
