<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReprintLabelRequest StructType
 * @subpackage Structs
 */
class ReprintLabelRequest extends AbstractStructBase
{
    /**
     * The LabelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LabelType;
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ParcelNumber;
    /**
     * The PrintType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PrintType;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The Client
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Client;
    /**
     * The ClientSiteOrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSiteOrderReference;
    /**
     * The ConsignmentNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNumber;
    /**
     * The PrinterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrinterID;
    /**
     * The ReasonForReprint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonForReprint;
    /**
     * The ReportData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReportData;
    /**
     * The RequestorID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestorID;
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Site;
    /**
     * The TemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateName;
    /**
     * The UPI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UPI;
    /**
     * Constructor method for ReprintLabelRequest
     * @uses ReprintLabelRequest::setLabelType()
     * @uses ReprintLabelRequest::setParcelNumber()
     * @uses ReprintLabelRequest::setPrintType()
     * @uses ReprintLabelRequest::setExtensionData()
     * @uses ReprintLabelRequest::setClient()
     * @uses ReprintLabelRequest::setClientSiteOrderReference()
     * @uses ReprintLabelRequest::setConsignmentNumber()
     * @uses ReprintLabelRequest::setPrinterID()
     * @uses ReprintLabelRequest::setReasonForReprint()
     * @uses ReprintLabelRequest::setReportData()
     * @uses ReprintLabelRequest::setRequestorID()
     * @uses ReprintLabelRequest::setSite()
     * @uses ReprintLabelRequest::setTemplateName()
     * @uses ReprintLabelRequest::setUPI()
     * @param string $labelType
     * @param int $parcelNumber
     * @param string $printType
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $client
     * @param string $clientSiteOrderReference
     * @param string $consignmentNumber
     * @param string $printerID
     * @param string $reasonForReprint
     * @param string $reportData
     * @param string $requestorID
     * @param string $site
     * @param string $templateName
     * @param string $uPI
     */
    public function __construct($labelType = null, $parcelNumber = null, $printType = null, \StructType\ExtensionDataObject $extensionData = null, $client = null, $clientSiteOrderReference = null, $consignmentNumber = null, $printerID = null, $reasonForReprint = null, $reportData = null, $requestorID = null, $site = null, $templateName = null, $uPI = null)
    {
        $this
            ->setLabelType($labelType)
            ->setParcelNumber($parcelNumber)
            ->setPrintType($printType)
            ->setExtensionData($extensionData)
            ->setClient($client)
            ->setClientSiteOrderReference($clientSiteOrderReference)
            ->setConsignmentNumber($consignmentNumber)
            ->setPrinterID($printerID)
            ->setReasonForReprint($reasonForReprint)
            ->setReportData($reportData)
            ->setRequestorID($requestorID)
            ->setSite($site)
            ->setTemplateName($templateName)
            ->setUPI($uPI);
    }
    /**
     * Get LabelType value
     * @return string
     */
    public function getLabelType()
    {
        return $this->LabelType;
    }
    /**
     * Set LabelType value
     * @uses \EnumType\LabelType::valueIsValid()
     * @uses \EnumType\LabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelType
     * @return \StructType\ReprintLabelRequest
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LabelType::valueIsValid($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LabelType', is_array($labelType) ? implode(', ', $labelType) : var_export($labelType, true), implode(', ', \EnumType\LabelType::getValidValues())), __LINE__);
        }
        $this->LabelType = $labelType;
        return $this;
    }
    /**
     * Get ParcelNumber value
     * @return int
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param int $parcelNumber
     * @return \StructType\ReprintLabelRequest
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !(is_int($parcelNumber) || ctype_digit($parcelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get PrintType value
     * @return string
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }
    /**
     * Set PrintType value
     * @uses \EnumType\PrintType::valueIsValid()
     * @uses \EnumType\PrintType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printType
     * @return \StructType\ReprintLabelRequest
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintType::valueIsValid($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintType', is_array($printType) ? implode(', ', $printType) : var_export($printType, true), implode(', ', \EnumType\PrintType::getValidValues())), __LINE__);
        }
        $this->PrintType = $printType;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ReprintLabelRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get Client value
     * @return string|null
     */
    public function getClient()
    {
        return $this->Client;
    }
    /**
     * Set Client value
     * @param string $client
     * @return \StructType\ReprintLabelRequest
     */
    public function setClient($client = null)
    {
        // validation for constraint: string
        if (!is_null($client) && !is_string($client)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($client, true), gettype($client)), __LINE__);
        }
        $this->Client = $client;
        return $this;
    }
    /**
     * Get ClientSiteOrderReference value
     * @return string|null
     */
    public function getClientSiteOrderReference()
    {
        return $this->ClientSiteOrderReference;
    }
    /**
     * Set ClientSiteOrderReference value
     * @param string $clientSiteOrderReference
     * @return \StructType\ReprintLabelRequest
     */
    public function setClientSiteOrderReference($clientSiteOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderReference) && !is_string($clientSiteOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderReference, true), gettype($clientSiteOrderReference)), __LINE__);
        }
        $this->ClientSiteOrderReference = $clientSiteOrderReference;
        return $this;
    }
    /**
     * Get ConsignmentNumber value
     * @return string|null
     */
    public function getConsignmentNumber()
    {
        return $this->ConsignmentNumber;
    }
    /**
     * Set ConsignmentNumber value
     * @param string $consignmentNumber
     * @return \StructType\ReprintLabelRequest
     */
    public function setConsignmentNumber($consignmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNumber) && !is_string($consignmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNumber, true), gettype($consignmentNumber)), __LINE__);
        }
        $this->ConsignmentNumber = $consignmentNumber;
        return $this;
    }
    /**
     * Get PrinterID value
     * @return string|null
     */
    public function getPrinterID()
    {
        return $this->PrinterID;
    }
    /**
     * Set PrinterID value
     * @param string $printerID
     * @return \StructType\ReprintLabelRequest
     */
    public function setPrinterID($printerID = null)
    {
        // validation for constraint: string
        if (!is_null($printerID) && !is_string($printerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerID, true), gettype($printerID)), __LINE__);
        }
        $this->PrinterID = $printerID;
        return $this;
    }
    /**
     * Get ReasonForReprint value
     * @return string|null
     */
    public function getReasonForReprint()
    {
        return $this->ReasonForReprint;
    }
    /**
     * Set ReasonForReprint value
     * @param string $reasonForReprint
     * @return \StructType\ReprintLabelRequest
     */
    public function setReasonForReprint($reasonForReprint = null)
    {
        // validation for constraint: string
        if (!is_null($reasonForReprint) && !is_string($reasonForReprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonForReprint, true), gettype($reasonForReprint)), __LINE__);
        }
        $this->ReasonForReprint = $reasonForReprint;
        return $this;
    }
    /**
     * Get ReportData value
     * @return string|null
     */
    public function getReportData()
    {
        return $this->ReportData;
    }
    /**
     * Set ReportData value
     * @param string $reportData
     * @return \StructType\ReprintLabelRequest
     */
    public function setReportData($reportData = null)
    {
        // validation for constraint: string
        if (!is_null($reportData) && !is_string($reportData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportData, true), gettype($reportData)), __LINE__);
        }
        $this->ReportData = $reportData;
        return $this;
    }
    /**
     * Get RequestorID value
     * @return string|null
     */
    public function getRequestorID()
    {
        return $this->RequestorID;
    }
    /**
     * Set RequestorID value
     * @param string $requestorID
     * @return \StructType\ReprintLabelRequest
     */
    public function setRequestorID($requestorID = null)
    {
        // validation for constraint: string
        if (!is_null($requestorID) && !is_string($requestorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestorID, true), gettype($requestorID)), __LINE__);
        }
        $this->RequestorID = $requestorID;
        return $this;
    }
    /**
     * Get Site value
     * @return string|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param string $site
     * @return \StructType\ReprintLabelRequest
     */
    public function setSite($site = null)
    {
        // validation for constraint: string
        if (!is_null($site) && !is_string($site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($site, true), gettype($site)), __LINE__);
        }
        $this->Site = $site;
        return $this;
    }
    /**
     * Get TemplateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->TemplateName;
    }
    /**
     * Set TemplateName value
     * @param string $templateName
     * @return \StructType\ReprintLabelRequest
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateName, true), gettype($templateName)), __LINE__);
        }
        $this->TemplateName = $templateName;
        return $this;
    }
    /**
     * Get UPI value
     * @return string|null
     */
    public function getUPI()
    {
        return $this->UPI;
    }
    /**
     * Set UPI value
     * @param string $uPI
     * @return \StructType\ReprintLabelRequest
     */
    public function setUPI($uPI = null)
    {
        // validation for constraint: string
        if (!is_null($uPI) && !is_string($uPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPI, true), gettype($uPI)), __LINE__);
        }
        $this->UPI = $uPI;
        return $this;
    }
}
