<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintManifestRequest StructType
 * @subpackage Structs
 */
class PrintManifestRequest extends AbstractStructBase
{
    /**
     * The ManifestID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ManifestID;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The PrinterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrinterID;
    /**
     * Constructor method for PrintManifestRequest
     * @uses PrintManifestRequest::setManifestID()
     * @uses PrintManifestRequest::setExtensionData()
     * @uses PrintManifestRequest::setPrinterID()
     * @param int $manifestID
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $printerID
     */
    public function __construct($manifestID = null, \StructType\ExtensionDataObject $extensionData = null, $printerID = null)
    {
        $this
            ->setManifestID($manifestID)
            ->setExtensionData($extensionData)
            ->setPrinterID($printerID);
    }
    /**
     * Get ManifestID value
     * @return int
     */
    public function getManifestID()
    {
        return $this->ManifestID;
    }
    /**
     * Set ManifestID value
     * @param int $manifestID
     * @return \StructType\PrintManifestRequest
     */
    public function setManifestID($manifestID = null)
    {
        // validation for constraint: int
        if (!is_null($manifestID) && !(is_int($manifestID) || ctype_digit($manifestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($manifestID, true), gettype($manifestID)), __LINE__);
        }
        $this->ManifestID = $manifestID;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\PrintManifestRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get PrinterID value
     * @return string|null
     */
    public function getPrinterID()
    {
        return $this->PrinterID;
    }
    /**
     * Set PrinterID value
     * @param string $printerID
     * @return \StructType\PrintManifestRequest
     */
    public function setPrinterID($printerID = null)
    {
        // validation for constraint: string
        if (!is_null($printerID) && !is_string($printerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerID, true), gettype($printerID)), __LINE__);
        }
        $this->PrinterID = $printerID;
        return $this;
    }
}
