<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for label StructType
 * @subpackage Structs
 */
class Label extends AbstractStructBase
{
    /**
     * The LabelType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LabelType;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The LabelPrinterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LabelPrinterID;
    /**
     * The LaserPrinterID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LaserPrinterID;
    /**
     * Constructor method for label
     * @uses Label::setLabelType()
     * @uses Label::setExtensionData()
     * @uses Label::setLabelPrinterID()
     * @uses Label::setLaserPrinterID()
     * @param string $labelType
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $labelPrinterID
     * @param string $laserPrinterID
     */
    public function __construct($labelType = null, \StructType\ExtensionDataObject $extensionData = null, $labelPrinterID = null, $laserPrinterID = null)
    {
        $this
            ->setLabelType($labelType)
            ->setExtensionData($extensionData)
            ->setLabelPrinterID($labelPrinterID)
            ->setLaserPrinterID($laserPrinterID);
    }
    /**
     * Get LabelType value
     * @return string
     */
    public function getLabelType()
    {
        return $this->LabelType;
    }
    /**
     * Set LabelType value
     * @uses \EnumType\LabelType::valueIsValid()
     * @uses \EnumType\LabelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelType
     * @return \StructType\Label
     */
    public function setLabelType($labelType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LabelType::valueIsValid($labelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LabelType', is_array($labelType) ? implode(', ', $labelType) : var_export($labelType, true), implode(', ', \EnumType\LabelType::getValidValues())), __LINE__);
        }
        $this->LabelType = $labelType;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\Label
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get LabelPrinterID value
     * @return string|null
     */
    public function getLabelPrinterID()
    {
        return $this->LabelPrinterID;
    }
    /**
     * Set LabelPrinterID value
     * @param string $labelPrinterID
     * @return \StructType\Label
     */
    public function setLabelPrinterID($labelPrinterID = null)
    {
        // validation for constraint: string
        if (!is_null($labelPrinterID) && !is_string($labelPrinterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelPrinterID, true), gettype($labelPrinterID)), __LINE__);
        }
        $this->LabelPrinterID = $labelPrinterID;
        return $this;
    }
    /**
     * Get LaserPrinterID value
     * @return string|null
     */
    public function getLaserPrinterID()
    {
        return $this->LaserPrinterID;
    }
    /**
     * Set LaserPrinterID value
     * @param string $laserPrinterID
     * @return \StructType\Label
     */
    public function setLaserPrinterID($laserPrinterID = null)
    {
        // validation for constraint: string
        if (!is_null($laserPrinterID) && !is_string($laserPrinterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($laserPrinterID, true), gettype($laserPrinterID)), __LINE__);
        }
        $this->LaserPrinterID = $laserPrinterID;
        return $this;
    }
}
