<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportTrackingRequest StructType
 * @subpackage Structs
 */
class ImportTrackingRequest extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The CarrierContract
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierContract;
    /**
     * Constructor method for ImportTrackingRequest
     * @uses ImportTrackingRequest::setExtensionData()
     * @uses ImportTrackingRequest::setCarrierCode()
     * @uses ImportTrackingRequest::setCarrierContract()
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $carrierContract
     */
    public function __construct(\StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $carrierContract = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setCarrierContract($carrierContract);
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ImportTrackingRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\ImportTrackingRequest
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get CarrierContract value
     * @return string|null
     */
    public function getCarrierContract()
    {
        return $this->CarrierContract;
    }
    /**
     * Set CarrierContract value
     * @param string $carrierContract
     * @return \StructType\ImportTrackingRequest
     */
    public function setCarrierContract($carrierContract = null)
    {
        // validation for constraint: string
        if (!is_null($carrierContract) && !is_string($carrierContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierContract, true), gettype($carrierContract)), __LINE__);
        }
        $this->CarrierContract = $carrierContract;
        return $this;
    }
}
