<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchOrderResultArgs StructType
 * @subpackage Structs
 */
class DespatchOrderResultArgs extends ResultArgs
{
    /**
     * The NewOrderStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NewOrderStatus;
    /**
     * Constructor method for DespatchOrderResultArgs
     * @uses DespatchOrderResultArgs::setNewOrderStatus()
     * @param string $newOrderStatus
     */
    public function __construct($newOrderStatus = null)
    {
        $this
            ->setNewOrderStatus($newOrderStatus);
    }
    /**
     * Get NewOrderStatus value
     * @return string
     */
    public function getNewOrderStatus()
    {
        return $this->NewOrderStatus;
    }
    /**
     * Set NewOrderStatus value
     * @uses \EnumType\DespatchOrderStatusType::valueIsValid()
     * @uses \EnumType\DespatchOrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newOrderStatus
     * @return \StructType\DespatchOrderResultArgs
     */
    public function setNewOrderStatus($newOrderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DespatchOrderStatusType::valueIsValid($newOrderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DespatchOrderStatusType', is_array($newOrderStatus) ? implode(', ', $newOrderStatus) : var_export($newOrderStatus, true), implode(', ', \EnumType\DespatchOrderStatusType::getValidValues())), __LINE__);
        }
        $this->NewOrderStatus = $newOrderStatus;
        return $this;
    }
}
