<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomsInfo StructType
 * @subpackage Structs
 */
class CustomsInfo extends AbstractStructBase
{
    /**
     * The DutyPaid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $DutyPaid;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CustomerIdentificationNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerIdentificationNo;
    /**
     * The CarriageValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CarriageValue;
    /**
     * The InsuranceValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $InsuranceValue;
    /**
     * The OtherValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $OtherValue;
    /**
     * Constructor method for CustomsInfo
     * @uses CustomsInfo::setDutyPaid()
     * @uses CustomsInfo::setExtensionData()
     * @uses CustomsInfo::setCustomerIdentificationNo()
     * @uses CustomsInfo::setCarriageValue()
     * @uses CustomsInfo::setInsuranceValue()
     * @uses CustomsInfo::setOtherValue()
     * @param bool $dutyPaid
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $customerIdentificationNo
     * @param float $carriageValue
     * @param float $insuranceValue
     * @param float $otherValue
     */
    public function __construct($dutyPaid = null, \StructType\ExtensionDataObject $extensionData = null, $customerIdentificationNo = null, $carriageValue = null, $insuranceValue = null, $otherValue = null)
    {
        $this
            ->setDutyPaid($dutyPaid)
            ->setExtensionData($extensionData)
            ->setCustomerIdentificationNo($customerIdentificationNo)
            ->setCarriageValue($carriageValue)
            ->setInsuranceValue($insuranceValue)
            ->setOtherValue($otherValue);
    }
    /**
     * Get DutyPaid value
     * @return bool
     */
    public function getDutyPaid()
    {
        return $this->DutyPaid;
    }
    /**
     * Set DutyPaid value
     * @param bool $dutyPaid
     * @return \StructType\CustomsInfo
     */
    public function setDutyPaid($dutyPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($dutyPaid) && !is_bool($dutyPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dutyPaid, true), gettype($dutyPaid)), __LINE__);
        }
        $this->DutyPaid = $dutyPaid;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\CustomsInfo
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CustomerIdentificationNo value
     * @return string|null
     */
    public function getCustomerIdentificationNo()
    {
        return $this->CustomerIdentificationNo;
    }
    /**
     * Set CustomerIdentificationNo value
     * @param string $customerIdentificationNo
     * @return \StructType\CustomsInfo
     */
    public function setCustomerIdentificationNo($customerIdentificationNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerIdentificationNo) && !is_string($customerIdentificationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerIdentificationNo, true), gettype($customerIdentificationNo)), __LINE__);
        }
        $this->CustomerIdentificationNo = $customerIdentificationNo;
        return $this;
    }
    /**
     * Get CarriageValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCarriageValue()
    {
        return isset($this->CarriageValue) ? $this->CarriageValue : null;
    }
    /**
     * Set CarriageValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $carriageValue
     * @return \StructType\CustomsInfo
     */
    public function setCarriageValue($carriageValue = null)
    {
        // validation for constraint: float
        if (!is_null($carriageValue) && !(is_float($carriageValue) || is_numeric($carriageValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($carriageValue, true), gettype($carriageValue)), __LINE__);
        }
        if (is_null($carriageValue) || (is_array($carriageValue) && empty($carriageValue))) {
            unset($this->CarriageValue);
        } else {
            $this->CarriageValue = $carriageValue;
        }
        return $this;
    }
    /**
     * Get InsuranceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getInsuranceValue()
    {
        return isset($this->InsuranceValue) ? $this->InsuranceValue : null;
    }
    /**
     * Set InsuranceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $insuranceValue
     * @return \StructType\CustomsInfo
     */
    public function setInsuranceValue($insuranceValue = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceValue) && !(is_float($insuranceValue) || is_numeric($insuranceValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceValue, true), gettype($insuranceValue)), __LINE__);
        }
        if (is_null($insuranceValue) || (is_array($insuranceValue) && empty($insuranceValue))) {
            unset($this->InsuranceValue);
        } else {
            $this->InsuranceValue = $insuranceValue;
        }
        return $this;
    }
    /**
     * Get OtherValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOtherValue()
    {
        return isset($this->OtherValue) ? $this->OtherValue : null;
    }
    /**
     * Set OtherValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $otherValue
     * @return \StructType\CustomsInfo
     */
    public function setOtherValue($otherValue = null)
    {
        // validation for constraint: float
        if (!is_null($otherValue) && !(is_float($otherValue) || is_numeric($otherValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($otherValue, true), gettype($otherValue)), __LINE__);
        }
        if (is_null($otherValue) || (is_array($otherValue) && empty($otherValue))) {
            unset($this->OtherValue);
        } else {
            $this->OtherValue = $otherValue;
        }
        return $this;
    }
}
