<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelConsignment StructType
 * @subpackage Structs
 */
class CancelConsignment extends AbstractStructBase
{
    /**
     * The clientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientCode;
    /**
     * The clientSiteOrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientSiteOrderReference;
    /**
     * Constructor method for CancelConsignment
     * @uses CancelConsignment::setClientCode()
     * @uses CancelConsignment::setClientSiteOrderReference()
     * @param string $clientCode
     * @param string $clientSiteOrderReference
     */
    public function __construct($clientCode = null, $clientSiteOrderReference = null)
    {
        $this
            ->setClientCode($clientCode)
            ->setClientSiteOrderReference($clientSiteOrderReference);
    }
    /**
     * Get clientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->clientCode;
    }
    /**
     * Set clientCode value
     * @param string $clientCode
     * @return \StructType\CancelConsignment
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->clientCode = $clientCode;
        return $this;
    }
    /**
     * Get clientSiteOrderReference value
     * @return string|null
     */
    public function getClientSiteOrderReference()
    {
        return $this->clientSiteOrderReference;
    }
    /**
     * Set clientSiteOrderReference value
     * @param string $clientSiteOrderReference
     * @return \StructType\CancelConsignment
     */
    public function setClientSiteOrderReference($clientSiteOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderReference) && !is_string($clientSiteOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderReference, true), gettype($clientSiteOrderReference)), __LINE__);
        }
        $this->clientSiteOrderReference = $clientSiteOrderReference;
        return $this;
    }
}
