<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TestExceptionLog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestExceptionLog $parameters
     * @return \StructType\TestExceptionLogResponse|bool
     */
    public function TestExceptionLog(\StructType\TestExceptionLog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestExceptionLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TestGeneralLog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestGeneralLog $parameters
     * @return \StructType\TestGeneralLogResponse|bool
     */
    public function TestGeneralLog(\StructType\TestGeneralLog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestGeneralLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TestExceptionLogResponse|\StructType\TestGeneralLogResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
