<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Despatch ServiceType
 * @subpackage Services
 */
class Despatch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DespatchParcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DespatchParcel $parameters
     * @return \StructType\DespatchParcelResponse|bool
     */
    public function DespatchParcel(\StructType\DespatchParcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DespatchParcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DespatchManagedOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DespatchManagedOrder $parameters
     * @return \StructType\DespatchManagedOrderResponse|bool
     */
    public function DespatchManagedOrder(\StructType\DespatchManagedOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DespatchManagedOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DespatchManagedOrderResponse|\StructType\DespatchParcelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
