<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bulk ServiceType
 * @subpackage Services
 */
class Bulk extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named BulkDespatchParcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\BulkDespatchParcel $parameters
     * @return \StructType\BulkDespatchParcelResponse|bool
     */
    public function BulkDespatchParcel(\StructType\BulkDespatchParcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BulkDespatchParcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\BulkDespatchParcelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
