<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSurcharge ArrayType
 * @subpackage Arrays
 */
class ArrayOfSurcharge extends AbstractStructArrayBase
{
    /**
     * The surcharge
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Surcharge[]
     */
    public $surcharge;
    /**
     * Constructor method for ArrayOfSurcharge
     * @uses ArrayOfSurcharge::setSurcharge()
     * @param \StructType\Surcharge[] $surcharge
     */
    public function __construct(array $surcharge = array())
    {
        $this
            ->setSurcharge($surcharge);
    }
    /**
     * Get surcharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Surcharge[]|null
     */
    public function getSurcharge()
    {
        return isset($this->surcharge) ? $this->surcharge : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSurcharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSurcharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSurchargeForArrayConstraintsFromSetSurcharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSurchargeSurchargeItem) {
            // validation for constraint: itemType
            if (!$arrayOfSurchargeSurchargeItem instanceof \StructType\Surcharge) {
                $invalidValues[] = is_object($arrayOfSurchargeSurchargeItem) ? get_class($arrayOfSurchargeSurchargeItem) : sprintf('%s(%s)', gettype($arrayOfSurchargeSurchargeItem), var_export($arrayOfSurchargeSurchargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The surcharge property can only contain items of type \StructType\Surcharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set surcharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Surcharge[] $surcharge
     * @return \ArrayType\ArrayOfSurcharge
     */
    public function setSurcharge(array $surcharge = array())
    {
        // validation for constraint: array
        if ('' !== ($surchargeArrayErrorMessage = self::validateSurchargeForArrayConstraintsFromSetSurcharge($surcharge))) {
            throw new \InvalidArgumentException($surchargeArrayErrorMessage, __LINE__);
        }
        if (is_null($surcharge) || (is_array($surcharge) && empty($surcharge))) {
            unset($this->surcharge);
        } else {
            $this->surcharge = $surcharge;
        }
        return $this;
    }
    /**
     * Add item to surcharge value
     * @throws \InvalidArgumentException
     * @param \StructType\Surcharge $item
     * @return \ArrayType\ArrayOfSurcharge
     */
    public function addToSurcharge(\StructType\Surcharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Surcharge) {
            throw new \InvalidArgumentException(sprintf('The surcharge property can only contain items of type \StructType\Surcharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->surcharge[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Surcharge|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Surcharge|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Surcharge|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Surcharge|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Surcharge|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string surcharge
     */
    public function getAttributeName()
    {
        return 'surcharge';
    }
}
