<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfParcelResponse ArrayType
 * @subpackage Arrays
 */
class ArrayOfParcelResponse extends AbstractStructArrayBase
{
    /**
     * The parcelResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelResponse[]
     */
    public $parcelResponse;
    /**
     * Constructor method for ArrayOfParcelResponse
     * @uses ArrayOfParcelResponse::setParcelResponse()
     * @param \StructType\ParcelResponse[] $parcelResponse
     */
    public function __construct(array $parcelResponse = array())
    {
        $this
            ->setParcelResponse($parcelResponse);
    }
    /**
     * Get parcelResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelResponse[]|null
     */
    public function getParcelResponse()
    {
        return isset($this->parcelResponse) ? $this->parcelResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcelResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcelResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelResponseForArrayConstraintsFromSetParcelResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfParcelResponseParcelResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfParcelResponseParcelResponseItem instanceof \StructType\ParcelResponse) {
                $invalidValues[] = is_object($arrayOfParcelResponseParcelResponseItem) ? get_class($arrayOfParcelResponseParcelResponseItem) : sprintf('%s(%s)', gettype($arrayOfParcelResponseParcelResponseItem), var_export($arrayOfParcelResponseParcelResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcelResponse property can only contain items of type \StructType\ParcelResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcelResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelResponse[] $parcelResponse
     * @return \ArrayType\ArrayOfParcelResponse
     */
    public function setParcelResponse(array $parcelResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelResponseArrayErrorMessage = self::validateParcelResponseForArrayConstraintsFromSetParcelResponse($parcelResponse))) {
            throw new \InvalidArgumentException($parcelResponseArrayErrorMessage, __LINE__);
        }
        if (is_null($parcelResponse) || (is_array($parcelResponse) && empty($parcelResponse))) {
            unset($this->parcelResponse);
        } else {
            $this->parcelResponse = $parcelResponse;
        }
        return $this;
    }
    /**
     * Add item to parcelResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelResponse $item
     * @return \ArrayType\ArrayOfParcelResponse
     */
    public function addToParcelResponse(\StructType\ParcelResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelResponse) {
            throw new \InvalidArgumentException(sprintf('The parcelResponse property can only contain items of type \StructType\ParcelResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcelResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ParcelResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ParcelResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ParcelResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ParcelResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ParcelResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string parcelResponse
     */
    public function getAttributeName()
    {
        return 'parcelResponse';
    }
}
