<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventInfo extends AbstractStructArrayBase
{
    /**
     * The EventInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EventInfo[]
     */
    public $EventInfo;
    /**
     * Constructor method for ArrayOfEventInfo
     * @uses ArrayOfEventInfo::setEventInfo()
     * @param \StructType\EventInfo[] $eventInfo
     */
    public function __construct(array $eventInfo = array())
    {
        $this
            ->setEventInfo($eventInfo);
    }
    /**
     * Get EventInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EventInfo[]|null
     */
    public function getEventInfo()
    {
        return isset($this->EventInfo) ? $this->EventInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventInfoForArrayConstraintsFromSetEventInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventInfoEventInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventInfoEventInfoItem instanceof \StructType\EventInfo) {
                $invalidValues[] = is_object($arrayOfEventInfoEventInfoItem) ? get_class($arrayOfEventInfoEventInfoItem) : sprintf('%s(%s)', gettype($arrayOfEventInfoEventInfoItem), var_export($arrayOfEventInfoEventInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventInfo property can only contain items of type \StructType\EventInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EventInfo[] $eventInfo
     * @return \ArrayType\ArrayOfEventInfo
     */
    public function setEventInfo(array $eventInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($eventInfoArrayErrorMessage = self::validateEventInfoForArrayConstraintsFromSetEventInfo($eventInfo))) {
            throw new \InvalidArgumentException($eventInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($eventInfo) || (is_array($eventInfo) && empty($eventInfo))) {
            unset($this->EventInfo);
        } else {
            $this->EventInfo = $eventInfo;
        }
        return $this;
    }
    /**
     * Add item to EventInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EventInfo $item
     * @return \ArrayType\ArrayOfEventInfo
     */
    public function addToEventInfo(\StructType\EventInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventInfo) {
            throw new \InvalidArgumentException(sprintf('The EventInfo property can only contain items of type \StructType\EventInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EventInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EventInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EventInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EventInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EventInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventInfo
     */
    public function getAttributeName()
    {
        return 'EventInfo';
    }
}
