<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScriptsRun StructType
 * @subpackage Structs
 */
class ScriptsRun extends AbstractStructBase
{
    /**
     * The EntryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EntryDate;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The EnteredBy
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnteredBy;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ScriptName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScriptName;
    /**
     * Constructor method for ScriptsRun
     * @uses ScriptsRun::setEntryDate()
     * @uses ScriptsRun::setExtensionData()
     * @uses ScriptsRun::setEnteredBy()
     * @uses ScriptsRun::setErrorMessage()
     * @uses ScriptsRun::setScriptName()
     * @param string $entryDate
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $enteredBy
     * @param string $errorMessage
     * @param string $scriptName
     */
    public function __construct($entryDate = null, \StructType\ExtensionDataObject $extensionData = null, $enteredBy = null, $errorMessage = null, $scriptName = null)
    {
        $this
            ->setEntryDate($entryDate)
            ->setExtensionData($extensionData)
            ->setEnteredBy($enteredBy)
            ->setErrorMessage($errorMessage)
            ->setScriptName($scriptName);
    }
    /**
     * Get EntryDate value
     * @return string
     */
    public function getEntryDate()
    {
        return $this->EntryDate;
    }
    /**
     * Set EntryDate value
     * @param string $entryDate
     * @return \StructType\ScriptsRun
     */
    public function setEntryDate($entryDate = null)
    {
        // validation for constraint: string
        if (!is_null($entryDate) && !is_string($entryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryDate, true), gettype($entryDate)), __LINE__);
        }
        $this->EntryDate = $entryDate;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ScriptsRun
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get EnteredBy value
     * @return string|null
     */
    public function getEnteredBy()
    {
        return $this->EnteredBy;
    }
    /**
     * Set EnteredBy value
     * @param string $enteredBy
     * @return \StructType\ScriptsRun
     */
    public function setEnteredBy($enteredBy = null)
    {
        // validation for constraint: string
        if (!is_null($enteredBy) && !is_string($enteredBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enteredBy, true), gettype($enteredBy)), __LINE__);
        }
        $this->EnteredBy = $enteredBy;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\ScriptsRun
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get ScriptName value
     * @return string|null
     */
    public function getScriptName()
    {
        return $this->ScriptName;
    }
    /**
     * Set ScriptName value
     * @param string $scriptName
     * @return \StructType\ScriptsRun
     */
    public function setScriptName($scriptName = null)
    {
        // validation for constraint: string
        if (!is_null($scriptName) && !is_string($scriptName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptName, true), gettype($scriptName)), __LINE__);
        }
        $this->ScriptName = $scriptName;
        return $this;
    }
}
