<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReprintLabelResponse StructType
 * @subpackage Structs
 */
class ReprintLabelResponse extends AbstractStructBase
{
    /**
     * The NumberOfPrintedItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfPrintedItems;
    /**
     * The Ok
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Ok;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The KeyValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePairOfstringanyType
     */
    public $KeyValues;
    /**
     * The RawPrinterData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RawPrinterData;
    /**
     * The ReportStreams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBase64Binary
     */
    public $ReportStreams;
    /**
     * The ReprintLabelResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReprintLabelResponse
     */
    public $ReprintLabelResult;
    /**
     * Constructor method for ReprintLabelResponse
     * @uses ReprintLabelResponse::setNumberOfPrintedItems()
     * @uses ReprintLabelResponse::setOk()
     * @uses ReprintLabelResponse::setExtensionData()
     * @uses ReprintLabelResponse::setErrorMessage()
     * @uses ReprintLabelResponse::setKeyValues()
     * @uses ReprintLabelResponse::setRawPrinterData()
     * @uses ReprintLabelResponse::setReportStreams()
     * @uses ReprintLabelResponse::setReprintLabelResult()
     * @param int $numberOfPrintedItems
     * @param bool $ok
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues
     * @param string $rawPrinterData
     * @param \ArrayType\ArrayOfBase64Binary $reportStreams
     * @param \StructType\ReprintLabelResponse $reprintLabelResult
     */
    public function __construct($numberOfPrintedItems = null, $ok = null, \StructType\ExtensionDataObject $extensionData = null, $errorMessage = null, \ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues = null, $rawPrinterData = null, \ArrayType\ArrayOfBase64Binary $reportStreams = null, \StructType\ReprintLabelResponse $reprintLabelResult = null)
    {
        $this
            ->setNumberOfPrintedItems($numberOfPrintedItems)
            ->setOk($ok)
            ->setExtensionData($extensionData)
            ->setErrorMessage($errorMessage)
            ->setKeyValues($keyValues)
            ->setRawPrinterData($rawPrinterData)
            ->setReportStreams($reportStreams)
            ->setReprintLabelResult($reprintLabelResult);
    }
    /**
     * Get NumberOfPrintedItems value
     * @return int
     */
    public function getNumberOfPrintedItems()
    {
        return $this->NumberOfPrintedItems;
    }
    /**
     * Set NumberOfPrintedItems value
     * @param int $numberOfPrintedItems
     * @return \StructType\ReprintLabelResponse
     */
    public function setNumberOfPrintedItems($numberOfPrintedItems = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPrintedItems) && !(is_int($numberOfPrintedItems) || ctype_digit($numberOfPrintedItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPrintedItems, true), gettype($numberOfPrintedItems)), __LINE__);
        }
        $this->NumberOfPrintedItems = $numberOfPrintedItems;
        return $this;
    }
    /**
     * Get Ok value
     * @return bool
     */
    public function getOk()
    {
        return $this->Ok;
    }
    /**
     * Set Ok value
     * @param bool $ok
     * @return \StructType\ReprintLabelResponse
     */
    public function setOk($ok = null)
    {
        // validation for constraint: boolean
        if (!is_null($ok) && !is_bool($ok)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ok, true), gettype($ok)), __LINE__);
        }
        $this->Ok = $ok;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ReprintLabelResponse
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\ReprintLabelResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get KeyValues value
     * @return \ArrayType\ArrayOfKeyValuePairOfstringanyType|null
     */
    public function getKeyValues()
    {
        return $this->KeyValues;
    }
    /**
     * Set KeyValues value
     * @param \ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues
     * @return \StructType\ReprintLabelResponse
     */
    public function setKeyValues(\ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues = null)
    {
        $this->KeyValues = $keyValues;
        return $this;
    }
    /**
     * Get RawPrinterData value
     * @return string|null
     */
    public function getRawPrinterData()
    {
        return $this->RawPrinterData;
    }
    /**
     * Set RawPrinterData value
     * @param string $rawPrinterData
     * @return \StructType\ReprintLabelResponse
     */
    public function setRawPrinterData($rawPrinterData = null)
    {
        // validation for constraint: string
        if (!is_null($rawPrinterData) && !is_string($rawPrinterData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rawPrinterData, true), gettype($rawPrinterData)), __LINE__);
        }
        $this->RawPrinterData = $rawPrinterData;
        return $this;
    }
    /**
     * Get ReportStreams value
     * @return \ArrayType\ArrayOfBase64Binary|null
     */
    public function getReportStreams()
    {
        return $this->ReportStreams;
    }
    /**
     * Set ReportStreams value
     * @param \ArrayType\ArrayOfBase64Binary $reportStreams
     * @return \StructType\ReprintLabelResponse
     */
    public function setReportStreams(\ArrayType\ArrayOfBase64Binary $reportStreams = null)
    {
        $this->ReportStreams = $reportStreams;
        return $this;
    }
    /**
     * Get ReprintLabelResult value
     * @return \StructType\ReprintLabelResponse|null
     */
    public function getReprintLabelResult()
    {
        return $this->ReprintLabelResult;
    }
    /**
     * Set ReprintLabelResult value
     * @param \StructType\ReprintLabelResponse $reprintLabelResult
     * @return \StructType\ReprintLabelResponse
     */
    public function setReprintLabelResult(\StructType\ReprintLabelResponse $reprintLabelResult = null)
    {
        $this->ReprintLabelResult = $reprintLabelResult;
        return $this;
    }
}
