<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The Depth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Depth;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Height;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ClientProductID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientProductID;
    /**
     * The CountryOfOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryOfOrigin;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FDANumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FDANumber;
    /**
     * The FabricContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FabricContent;
    /**
     * The HarmonisedCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HarmonisedCode;
    /**
     * The ProductID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ProductID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The Sku
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sku;
    /**
     * The TypeDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDescription;
    /**
     * The UnitValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UnitValue;
    /**
     * The UnitWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $UnitWeight;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Width;
    /**
     * Constructor method for product
     * @uses Product::setDepth()
     * @uses Product::setHeight()
     * @uses Product::setExtensionData()
     * @uses Product::setClientProductID()
     * @uses Product::setCountryOfOrigin()
     * @uses Product::setDescription()
     * @uses Product::setFDANumber()
     * @uses Product::setFabricContent()
     * @uses Product::setHarmonisedCode()
     * @uses Product::setProductID()
     * @uses Product::setQuantity()
     * @uses Product::setSku()
     * @uses Product::setTypeDescription()
     * @uses Product::setUnitValue()
     * @uses Product::setUnitWeight()
     * @uses Product::setWidth()
     * @param float $depth
     * @param float $height
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $clientProductID
     * @param string $countryOfOrigin
     * @param string $description
     * @param string $fDANumber
     * @param string $fabricContent
     * @param string $harmonisedCode
     * @param int $productID
     * @param int $quantity
     * @param string $sku
     * @param string $typeDescription
     * @param float $unitValue
     * @param float $unitWeight
     * @param float $width
     */
    public function __construct($depth = null, $height = null, \StructType\ExtensionDataObject $extensionData = null, $clientProductID = null, $countryOfOrigin = null, $description = null, $fDANumber = null, $fabricContent = null, $harmonisedCode = null, $productID = null, $quantity = null, $sku = null, $typeDescription = null, $unitValue = null, $unitWeight = null, $width = null)
    {
        $this
            ->setDepth($depth)
            ->setHeight($height)
            ->setExtensionData($extensionData)
            ->setClientProductID($clientProductID)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setDescription($description)
            ->setFDANumber($fDANumber)
            ->setFabricContent($fabricContent)
            ->setHarmonisedCode($harmonisedCode)
            ->setProductID($productID)
            ->setQuantity($quantity)
            ->setSku($sku)
            ->setTypeDescription($typeDescription)
            ->setUnitValue($unitValue)
            ->setUnitWeight($unitWeight)
            ->setWidth($width);
    }
    /**
     * Get Depth value
     * @return float
     */
    public function getDepth()
    {
        return $this->Depth;
    }
    /**
     * Set Depth value
     * @param float $depth
     * @return \StructType\Product
     */
    public function setDepth($depth = null)
    {
        // validation for constraint: float
        if (!is_null($depth) && !(is_float($depth) || is_numeric($depth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depth, true), gettype($depth)), __LINE__);
        }
        $this->Depth = $depth;
        return $this;
    }
    /**
     * Get Height value
     * @return float
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param float $height
     * @return \StructType\Product
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\Product
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ClientProductID value
     * @return string|null
     */
    public function getClientProductID()
    {
        return $this->ClientProductID;
    }
    /**
     * Set ClientProductID value
     * @param string $clientProductID
     * @return \StructType\Product
     */
    public function setClientProductID($clientProductID = null)
    {
        // validation for constraint: string
        if (!is_null($clientProductID) && !is_string($clientProductID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientProductID, true), gettype($clientProductID)), __LINE__);
        }
        $this->ClientProductID = $clientProductID;
        return $this;
    }
    /**
     * Get CountryOfOrigin value
     * @return string|null
     */
    public function getCountryOfOrigin()
    {
        return $this->CountryOfOrigin;
    }
    /**
     * Set CountryOfOrigin value
     * @param string $countryOfOrigin
     * @return \StructType\Product
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        $this->CountryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Product
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FDANumber value
     * @return string|null
     */
    public function getFDANumber()
    {
        return $this->FDANumber;
    }
    /**
     * Set FDANumber value
     * @param string $fDANumber
     * @return \StructType\Product
     */
    public function setFDANumber($fDANumber = null)
    {
        // validation for constraint: string
        if (!is_null($fDANumber) && !is_string($fDANumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fDANumber, true), gettype($fDANumber)), __LINE__);
        }
        $this->FDANumber = $fDANumber;
        return $this;
    }
    /**
     * Get FabricContent value
     * @return string|null
     */
    public function getFabricContent()
    {
        return $this->FabricContent;
    }
    /**
     * Set FabricContent value
     * @param string $fabricContent
     * @return \StructType\Product
     */
    public function setFabricContent($fabricContent = null)
    {
        // validation for constraint: string
        if (!is_null($fabricContent) && !is_string($fabricContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fabricContent, true), gettype($fabricContent)), __LINE__);
        }
        $this->FabricContent = $fabricContent;
        return $this;
    }
    /**
     * Get HarmonisedCode value
     * @return string|null
     */
    public function getHarmonisedCode()
    {
        return $this->HarmonisedCode;
    }
    /**
     * Set HarmonisedCode value
     * @param string $harmonisedCode
     * @return \StructType\Product
     */
    public function setHarmonisedCode($harmonisedCode = null)
    {
        // validation for constraint: string
        if (!is_null($harmonisedCode) && !is_string($harmonisedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($harmonisedCode, true), gettype($harmonisedCode)), __LINE__);
        }
        $this->HarmonisedCode = $harmonisedCode;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \StructType\Product
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !(is_int($productID) || ctype_digit($productID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \StructType\Product
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get Sku value
     * @return string|null
     */
    public function getSku()
    {
        return $this->Sku;
    }
    /**
     * Set Sku value
     * @param string $sku
     * @return \StructType\Product
     */
    public function setSku($sku = null)
    {
        // validation for constraint: string
        if (!is_null($sku) && !is_string($sku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sku, true), gettype($sku)), __LINE__);
        }
        $this->Sku = $sku;
        return $this;
    }
    /**
     * Get TypeDescription value
     * @return string|null
     */
    public function getTypeDescription()
    {
        return $this->TypeDescription;
    }
    /**
     * Set TypeDescription value
     * @param string $typeDescription
     * @return \StructType\Product
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDescription, true), gettype($typeDescription)), __LINE__);
        }
        $this->TypeDescription = $typeDescription;
        return $this;
    }
    /**
     * Get UnitValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUnitValue()
    {
        return isset($this->UnitValue) ? $this->UnitValue : null;
    }
    /**
     * Set UnitValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $unitValue
     * @return \StructType\Product
     */
    public function setUnitValue($unitValue = null)
    {
        // validation for constraint: float
        if (!is_null($unitValue) && !(is_float($unitValue) || is_numeric($unitValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitValue, true), gettype($unitValue)), __LINE__);
        }
        if (is_null($unitValue) || (is_array($unitValue) && empty($unitValue))) {
            unset($this->UnitValue);
        } else {
            $this->UnitValue = $unitValue;
        }
        return $this;
    }
    /**
     * Get UnitWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getUnitWeight()
    {
        return isset($this->UnitWeight) ? $this->UnitWeight : null;
    }
    /**
     * Set UnitWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $unitWeight
     * @return \StructType\Product
     */
    public function setUnitWeight($unitWeight = null)
    {
        // validation for constraint: float
        if (!is_null($unitWeight) && !(is_float($unitWeight) || is_numeric($unitWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitWeight, true), gettype($unitWeight)), __LINE__);
        }
        if (is_null($unitWeight) || (is_array($unitWeight) && empty($unitWeight))) {
            unset($this->UnitWeight);
        } else {
            $this->UnitWeight = $unitWeight;
        }
        return $this;
    }
    /**
     * Get Width value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWidth()
    {
        return isset($this->Width) ? $this->Width : null;
    }
    /**
     * Set Width value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $width
     * @return \StructType\Product
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        if (is_null($width) || (is_array($width) && empty($width))) {
            unset($this->Width);
        } else {
            $this->Width = $width;
        }
        return $this;
    }
}
