<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintsCountResponse StructType
 * @subpackage Structs
 */
class PrintsCountResponse extends AbstractStructBase
{
    /**
     * The PrintsCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PrintsCount;
    /**
     * The Successful
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Successful;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for PrintsCountResponse
     * @uses PrintsCountResponse::setPrintsCount()
     * @uses PrintsCountResponse::setSuccessful()
     * @uses PrintsCountResponse::setExtensionData()
     * @uses PrintsCountResponse::setErrorMessage()
     * @param int $printsCount
     * @param bool $successful
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $errorMessage
     */
    public function __construct($printsCount = null, $successful = null, \StructType\ExtensionDataObject $extensionData = null, $errorMessage = null)
    {
        $this
            ->setPrintsCount($printsCount)
            ->setSuccessful($successful)
            ->setExtensionData($extensionData)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get PrintsCount value
     * @return int
     */
    public function getPrintsCount()
    {
        return $this->PrintsCount;
    }
    /**
     * Set PrintsCount value
     * @param int $printsCount
     * @return \StructType\PrintsCountResponse
     */
    public function setPrintsCount($printsCount = null)
    {
        // validation for constraint: int
        if (!is_null($printsCount) && !(is_int($printsCount) || ctype_digit($printsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printsCount, true), gettype($printsCount)), __LINE__);
        }
        $this->PrintsCount = $printsCount;
        return $this;
    }
    /**
     * Get Successful value
     * @return bool
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\PrintsCountResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\PrintsCountResponse
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\PrintsCountResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
