<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintsCountRequest StructType
 * @subpackage Structs
 */
class PrintsCountRequest extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientSite
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSite;
    /**
     * The ClientSiteOrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSiteOrderReference;
    /**
     * The Upi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Upi;
    /**
     * Constructor method for PrintsCountRequest
     * @uses PrintsCountRequest::setExtensionData()
     * @uses PrintsCountRequest::setClientCode()
     * @uses PrintsCountRequest::setClientSite()
     * @uses PrintsCountRequest::setClientSiteOrderReference()
     * @uses PrintsCountRequest::setUpi()
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $clientCode
     * @param string $clientSite
     * @param string $clientSiteOrderReference
     * @param string $upi
     */
    public function __construct(\StructType\ExtensionDataObject $extensionData = null, $clientCode = null, $clientSite = null, $clientSiteOrderReference = null, $upi = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setClientCode($clientCode)
            ->setClientSite($clientSite)
            ->setClientSiteOrderReference($clientSiteOrderReference)
            ->setUpi($upi);
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\PrintsCountRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\PrintsCountRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ClientSite value
     * @return string|null
     */
    public function getClientSite()
    {
        return $this->ClientSite;
    }
    /**
     * Set ClientSite value
     * @param string $clientSite
     * @return \StructType\PrintsCountRequest
     */
    public function setClientSite($clientSite = null)
    {
        // validation for constraint: string
        if (!is_null($clientSite) && !is_string($clientSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSite, true), gettype($clientSite)), __LINE__);
        }
        $this->ClientSite = $clientSite;
        return $this;
    }
    /**
     * Get ClientSiteOrderReference value
     * @return string|null
     */
    public function getClientSiteOrderReference()
    {
        return $this->ClientSiteOrderReference;
    }
    /**
     * Set ClientSiteOrderReference value
     * @param string $clientSiteOrderReference
     * @return \StructType\PrintsCountRequest
     */
    public function setClientSiteOrderReference($clientSiteOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderReference) && !is_string($clientSiteOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderReference, true), gettype($clientSiteOrderReference)), __LINE__);
        }
        $this->ClientSiteOrderReference = $clientSiteOrderReference;
        return $this;
    }
    /**
     * Get Upi value
     * @return string|null
     */
    public function getUpi()
    {
        return $this->Upi;
    }
    /**
     * Set Upi value
     * @param string $upi
     * @return \StructType\PrintsCountRequest
     */
    public function setUpi($upi = null)
    {
        // validation for constraint: string
        if (!is_null($upi) && !is_string($upi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upi, true), gettype($upi)), __LINE__);
        }
        $this->Upi = $upi;
        return $this;
    }
}
