<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintServerLabelAuditRequest StructType
 * @subpackage Structs
 */
class PrintServerLabelAuditRequest extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Category;
    /**
     * The LabelID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LabelID;
    /**
     * The RequestedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RequestedOn;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The PrinterName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrinterName;
    /**
     * The TemplateData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateData;
    /**
     * The TemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateName;
    /**
     * Constructor method for PrintServerLabelAuditRequest
     * @uses PrintServerLabelAuditRequest::setCategory()
     * @uses PrintServerLabelAuditRequest::setLabelID()
     * @uses PrintServerLabelAuditRequest::setRequestedOn()
     * @uses PrintServerLabelAuditRequest::setSuccess()
     * @uses PrintServerLabelAuditRequest::setExtensionData()
     * @uses PrintServerLabelAuditRequest::setErrorMessage()
     * @uses PrintServerLabelAuditRequest::setPrinterName()
     * @uses PrintServerLabelAuditRequest::setTemplateData()
     * @uses PrintServerLabelAuditRequest::setTemplateName()
     * @param int $category
     * @param int $labelID
     * @param string $requestedOn
     * @param bool $success
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $errorMessage
     * @param string $printerName
     * @param string $templateData
     * @param string $templateName
     */
    public function __construct($category = null, $labelID = null, $requestedOn = null, $success = null, \StructType\ExtensionDataObject $extensionData = null, $errorMessage = null, $printerName = null, $templateData = null, $templateName = null)
    {
        $this
            ->setCategory($category)
            ->setLabelID($labelID)
            ->setRequestedOn($requestedOn)
            ->setSuccess($success)
            ->setExtensionData($extensionData)
            ->setErrorMessage($errorMessage)
            ->setPrinterName($printerName)
            ->setTemplateData($templateData)
            ->setTemplateName($templateName);
    }
    /**
     * Get Category value
     * @return int
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param int $category
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setCategory($category = null)
    {
        // validation for constraint: int
        if (!is_null($category) && !(is_int($category) || ctype_digit($category))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get LabelID value
     * @return int
     */
    public function getLabelID()
    {
        return $this->LabelID;
    }
    /**
     * Set LabelID value
     * @param int $labelID
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setLabelID($labelID = null)
    {
        // validation for constraint: int
        if (!is_null($labelID) && !(is_int($labelID) || ctype_digit($labelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($labelID, true), gettype($labelID)), __LINE__);
        }
        $this->LabelID = $labelID;
        return $this;
    }
    /**
     * Get RequestedOn value
     * @return string
     */
    public function getRequestedOn()
    {
        return $this->RequestedOn;
    }
    /**
     * Set RequestedOn value
     * @param string $requestedOn
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setRequestedOn($requestedOn = null)
    {
        // validation for constraint: string
        if (!is_null($requestedOn) && !is_string($requestedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestedOn, true), gettype($requestedOn)), __LINE__);
        }
        $this->RequestedOn = $requestedOn;
        return $this;
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get PrinterName value
     * @return string|null
     */
    public function getPrinterName()
    {
        return $this->PrinterName;
    }
    /**
     * Set PrinterName value
     * @param string $printerName
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setPrinterName($printerName = null)
    {
        // validation for constraint: string
        if (!is_null($printerName) && !is_string($printerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerName, true), gettype($printerName)), __LINE__);
        }
        $this->PrinterName = $printerName;
        return $this;
    }
    /**
     * Get TemplateData value
     * @return string|null
     */
    public function getTemplateData()
    {
        return $this->TemplateData;
    }
    /**
     * Set TemplateData value
     * @param string $templateData
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setTemplateData($templateData = null)
    {
        // validation for constraint: string
        if (!is_null($templateData) && !is_string($templateData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateData, true), gettype($templateData)), __LINE__);
        }
        $this->TemplateData = $templateData;
        return $this;
    }
    /**
     * Get TemplateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->TemplateName;
    }
    /**
     * Set TemplateName value
     * @param string $templateName
     * @return \StructType\PrintServerLabelAuditRequest
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateName, true), gettype($templateName)), __LINE__);
        }
        $this->TemplateName = $templateName;
        return $this;
    }
}
