<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintLabelResponse StructType
 * @subpackage Structs
 */
class PrintLabelResponse extends AbstractStructBase
{
    /**
     * The NumberOfPrintedItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberOfPrintedItems;
    /**
     * The Ok
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Ok;
    /**
     * The ResponseType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResponseType;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The KeyValues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfKeyValuePairOfstringanyType
     */
    public $KeyValues;
    /**
     * The RawPrinterData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RawPrinterData;
    /**
     * The ReportStreams
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBase64Binary
     */
    public $ReportStreams;
    /**
     * The TemplateName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TemplateName;
    /**
     * The UniuniqueParcelIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniuniqueParcelIdentifier;
    /**
     * The PrintLabelResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPrintLabelResponse
     */
    public $PrintLabelResult;
    /**
     * Constructor method for PrintLabelResponse
     * @uses PrintLabelResponse::setNumberOfPrintedItems()
     * @uses PrintLabelResponse::setOk()
     * @uses PrintLabelResponse::setResponseType()
     * @uses PrintLabelResponse::setExtensionData()
     * @uses PrintLabelResponse::setErrorMessage()
     * @uses PrintLabelResponse::setKeyValues()
     * @uses PrintLabelResponse::setRawPrinterData()
     * @uses PrintLabelResponse::setReportStreams()
     * @uses PrintLabelResponse::setTemplateName()
     * @uses PrintLabelResponse::setUniuniqueParcelIdentifier()
     * @uses PrintLabelResponse::setPrintLabelResult()
     * @param int $numberOfPrintedItems
     * @param bool $ok
     * @param string $responseType
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues
     * @param string $rawPrinterData
     * @param \ArrayType\ArrayOfBase64Binary $reportStreams
     * @param string $templateName
     * @param string $uniuniqueParcelIdentifier
     * @param \ArrayType\ArrayOfPrintLabelResponse $printLabelResult
     */
    public function __construct($numberOfPrintedItems = null, $ok = null, $responseType = null, \StructType\ExtensionDataObject $extensionData = null, $errorMessage = null, \ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues = null, $rawPrinterData = null, \ArrayType\ArrayOfBase64Binary $reportStreams = null, $templateName = null, $uniuniqueParcelIdentifier = null, \ArrayType\ArrayOfPrintLabelResponse $printLabelResult = null)
    {
        $this
            ->setNumberOfPrintedItems($numberOfPrintedItems)
            ->setOk($ok)
            ->setResponseType($responseType)
            ->setExtensionData($extensionData)
            ->setErrorMessage($errorMessage)
            ->setKeyValues($keyValues)
            ->setRawPrinterData($rawPrinterData)
            ->setReportStreams($reportStreams)
            ->setTemplateName($templateName)
            ->setUniuniqueParcelIdentifier($uniuniqueParcelIdentifier)
            ->setPrintLabelResult($printLabelResult);
    }
    /**
     * Get NumberOfPrintedItems value
     * @return int
     */
    public function getNumberOfPrintedItems()
    {
        return $this->NumberOfPrintedItems;
    }
    /**
     * Set NumberOfPrintedItems value
     * @param int $numberOfPrintedItems
     * @return \StructType\PrintLabelResponse
     */
    public function setNumberOfPrintedItems($numberOfPrintedItems = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPrintedItems) && !(is_int($numberOfPrintedItems) || ctype_digit($numberOfPrintedItems))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPrintedItems, true), gettype($numberOfPrintedItems)), __LINE__);
        }
        $this->NumberOfPrintedItems = $numberOfPrintedItems;
        return $this;
    }
    /**
     * Get Ok value
     * @return bool
     */
    public function getOk()
    {
        return $this->Ok;
    }
    /**
     * Set Ok value
     * @param bool $ok
     * @return \StructType\PrintLabelResponse
     */
    public function setOk($ok = null)
    {
        // validation for constraint: boolean
        if (!is_null($ok) && !is_bool($ok)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ok, true), gettype($ok)), __LINE__);
        }
        $this->Ok = $ok;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @uses \EnumType\PrintLabelResponseTypes::valueIsValid()
     * @uses \EnumType\PrintLabelResponseTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $responseType
     * @return \StructType\PrintLabelResponse
     */
    public function setResponseType($responseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintLabelResponseTypes::valueIsValid($responseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintLabelResponseTypes', is_array($responseType) ? implode(', ', $responseType) : var_export($responseType, true), implode(', ', \EnumType\PrintLabelResponseTypes::getValidValues())), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\PrintLabelResponse
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\PrintLabelResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get KeyValues value
     * @return \ArrayType\ArrayOfKeyValuePairOfstringanyType|null
     */
    public function getKeyValues()
    {
        return $this->KeyValues;
    }
    /**
     * Set KeyValues value
     * @param \ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues
     * @return \StructType\PrintLabelResponse
     */
    public function setKeyValues(\ArrayType\ArrayOfKeyValuePairOfstringanyType $keyValues = null)
    {
        $this->KeyValues = $keyValues;
        return $this;
    }
    /**
     * Get RawPrinterData value
     * @return string|null
     */
    public function getRawPrinterData()
    {
        return $this->RawPrinterData;
    }
    /**
     * Set RawPrinterData value
     * @param string $rawPrinterData
     * @return \StructType\PrintLabelResponse
     */
    public function setRawPrinterData($rawPrinterData = null)
    {
        // validation for constraint: string
        if (!is_null($rawPrinterData) && !is_string($rawPrinterData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rawPrinterData, true), gettype($rawPrinterData)), __LINE__);
        }
        $this->RawPrinterData = $rawPrinterData;
        return $this;
    }
    /**
     * Get ReportStreams value
     * @return \ArrayType\ArrayOfBase64Binary|null
     */
    public function getReportStreams()
    {
        return $this->ReportStreams;
    }
    /**
     * Set ReportStreams value
     * @param \ArrayType\ArrayOfBase64Binary $reportStreams
     * @return \StructType\PrintLabelResponse
     */
    public function setReportStreams(\ArrayType\ArrayOfBase64Binary $reportStreams = null)
    {
        $this->ReportStreams = $reportStreams;
        return $this;
    }
    /**
     * Get TemplateName value
     * @return string|null
     */
    public function getTemplateName()
    {
        return $this->TemplateName;
    }
    /**
     * Set TemplateName value
     * @param string $templateName
     * @return \StructType\PrintLabelResponse
     */
    public function setTemplateName($templateName = null)
    {
        // validation for constraint: string
        if (!is_null($templateName) && !is_string($templateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($templateName, true), gettype($templateName)), __LINE__);
        }
        $this->TemplateName = $templateName;
        return $this;
    }
    /**
     * Get UniuniqueParcelIdentifier value
     * @return string|null
     */
    public function getUniuniqueParcelIdentifier()
    {
        return $this->UniuniqueParcelIdentifier;
    }
    /**
     * Set UniuniqueParcelIdentifier value
     * @param string $uniuniqueParcelIdentifier
     * @return \StructType\PrintLabelResponse
     */
    public function setUniuniqueParcelIdentifier($uniuniqueParcelIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($uniuniqueParcelIdentifier) && !is_string($uniuniqueParcelIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniuniqueParcelIdentifier, true), gettype($uniuniqueParcelIdentifier)), __LINE__);
        }
        $this->UniuniqueParcelIdentifier = $uniuniqueParcelIdentifier;
        return $this;
    }
    /**
     * Get PrintLabelResult value
     * @return \ArrayType\ArrayOfPrintLabelResponse|null
     */
    public function getPrintLabelResult()
    {
        return $this->PrintLabelResult;
    }
    /**
     * Set PrintLabelResult value
     * @param \ArrayType\ArrayOfPrintLabelResponse $printLabelResult
     * @return \StructType\PrintLabelResponse
     */
    public function setPrintLabelResult(\ArrayType\ArrayOfPrintLabelResponse $printLabelResult = null)
    {
        $this->PrintLabelResult = $printLabelResult;
        return $this;
    }
}
