<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrintLabelRequest StructType
 * @subpackage Structs
 */
class PrintLabelRequest extends AbstractStructBase
{
    /**
     * The NoPrintRequired
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NoPrintRequired;
    /**
     * The PrintType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PrintType;
    /**
     * The SiteOrderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SiteOrderID;
    /**
     * The Successful
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Successful;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientSiteOrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSiteOrderReference;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Labels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLabel
     */
    public $Labels;
    /**
     * The Upi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Upi;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for PrintLabelRequest
     * @uses PrintLabelRequest::setNoPrintRequired()
     * @uses PrintLabelRequest::setPrintType()
     * @uses PrintLabelRequest::setSiteOrderID()
     * @uses PrintLabelRequest::setSuccessful()
     * @uses PrintLabelRequest::setExtensionData()
     * @uses PrintLabelRequest::setClientCode()
     * @uses PrintLabelRequest::setClientSiteOrderReference()
     * @uses PrintLabelRequest::setErrorMessage()
     * @uses PrintLabelRequest::setLabels()
     * @uses PrintLabelRequest::setUpi()
     * @uses PrintLabelRequest::setUserName()
     * @param bool $noPrintRequired
     * @param string $printType
     * @param int $siteOrderID
     * @param bool $successful
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $clientCode
     * @param string $clientSiteOrderReference
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfLabel $labels
     * @param string $upi
     * @param string $userName
     */
    public function __construct($noPrintRequired = null, $printType = null, $siteOrderID = null, $successful = null, \StructType\ExtensionDataObject $extensionData = null, $clientCode = null, $clientSiteOrderReference = null, $errorMessage = null, \ArrayType\ArrayOfLabel $labels = null, $upi = null, $userName = null)
    {
        $this
            ->setNoPrintRequired($noPrintRequired)
            ->setPrintType($printType)
            ->setSiteOrderID($siteOrderID)
            ->setSuccessful($successful)
            ->setExtensionData($extensionData)
            ->setClientCode($clientCode)
            ->setClientSiteOrderReference($clientSiteOrderReference)
            ->setErrorMessage($errorMessage)
            ->setLabels($labels)
            ->setUpi($upi)
            ->setUserName($userName);
    }
    /**
     * Get NoPrintRequired value
     * @return bool
     */
    public function getNoPrintRequired()
    {
        return $this->NoPrintRequired;
    }
    /**
     * Set NoPrintRequired value
     * @param bool $noPrintRequired
     * @return \StructType\PrintLabelRequest
     */
    public function setNoPrintRequired($noPrintRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($noPrintRequired) && !is_bool($noPrintRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noPrintRequired, true), gettype($noPrintRequired)), __LINE__);
        }
        $this->NoPrintRequired = $noPrintRequired;
        return $this;
    }
    /**
     * Get PrintType value
     * @return string
     */
    public function getPrintType()
    {
        return $this->PrintType;
    }
    /**
     * Set PrintType value
     * @uses \EnumType\PrintType::valueIsValid()
     * @uses \EnumType\PrintType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printType
     * @return \StructType\PrintLabelRequest
     */
    public function setPrintType($printType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrintType::valueIsValid($printType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PrintType', is_array($printType) ? implode(', ', $printType) : var_export($printType, true), implode(', ', \EnumType\PrintType::getValidValues())), __LINE__);
        }
        $this->PrintType = $printType;
        return $this;
    }
    /**
     * Get SiteOrderID value
     * @return int
     */
    public function getSiteOrderID()
    {
        return $this->SiteOrderID;
    }
    /**
     * Set SiteOrderID value
     * @param int $siteOrderID
     * @return \StructType\PrintLabelRequest
     */
    public function setSiteOrderID($siteOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($siteOrderID) && !(is_int($siteOrderID) || ctype_digit($siteOrderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siteOrderID, true), gettype($siteOrderID)), __LINE__);
        }
        $this->SiteOrderID = $siteOrderID;
        return $this;
    }
    /**
     * Get Successful value
     * @return bool
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\PrintLabelRequest
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\PrintLabelRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\PrintLabelRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ClientSiteOrderReference value
     * @return string|null
     */
    public function getClientSiteOrderReference()
    {
        return $this->ClientSiteOrderReference;
    }
    /**
     * Set ClientSiteOrderReference value
     * @param string $clientSiteOrderReference
     * @return \StructType\PrintLabelRequest
     */
    public function setClientSiteOrderReference($clientSiteOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderReference) && !is_string($clientSiteOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderReference, true), gettype($clientSiteOrderReference)), __LINE__);
        }
        $this->ClientSiteOrderReference = $clientSiteOrderReference;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\PrintLabelRequest
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Labels value
     * @return \ArrayType\ArrayOfLabel|null
     */
    public function getLabels()
    {
        return $this->Labels;
    }
    /**
     * Set Labels value
     * @param \ArrayType\ArrayOfLabel $labels
     * @return \StructType\PrintLabelRequest
     */
    public function setLabels(\ArrayType\ArrayOfLabel $labels = null)
    {
        $this->Labels = $labels;
        return $this;
    }
    /**
     * Get Upi value
     * @return string|null
     */
    public function getUpi()
    {
        return $this->Upi;
    }
    /**
     * Set Upi value
     * @param string $upi
     * @return \StructType\PrintLabelRequest
     */
    public function setUpi($upi = null)
    {
        // validation for constraint: string
        if (!is_null($upi) && !is_string($upi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upi, true), gettype($upi)), __LINE__);
        }
        $this->Upi = $upi;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\PrintLabelRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
}
