<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelResponse StructType
 * @subpackage Structs
 */
class ParcelResponse extends AbstractStructBase
{
    /**
     * The ParcelNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ParcelNumber;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The BarcodeContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeContent;
    /**
     * The ParcelUPI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParcelUPI;
    /**
     * The TrackingUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingUrl;
    /**
     * Constructor method for parcelResponse
     * @uses ParcelResponse::setParcelNumber()
     * @uses ParcelResponse::setExtensionData()
     * @uses ParcelResponse::setBarcodeContent()
     * @uses ParcelResponse::setParcelUPI()
     * @uses ParcelResponse::setTrackingUrl()
     * @param int $parcelNumber
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $barcodeContent
     * @param string $parcelUPI
     * @param string $trackingUrl
     */
    public function __construct($parcelNumber = null, \StructType\ExtensionDataObject $extensionData = null, $barcodeContent = null, $parcelUPI = null, $trackingUrl = null)
    {
        $this
            ->setParcelNumber($parcelNumber)
            ->setExtensionData($extensionData)
            ->setBarcodeContent($barcodeContent)
            ->setParcelUPI($parcelUPI)
            ->setTrackingUrl($trackingUrl);
    }
    /**
     * Get ParcelNumber value
     * @return int
     */
    public function getParcelNumber()
    {
        return $this->ParcelNumber;
    }
    /**
     * Set ParcelNumber value
     * @param int $parcelNumber
     * @return \StructType\ParcelResponse
     */
    public function setParcelNumber($parcelNumber = null)
    {
        // validation for constraint: int
        if (!is_null($parcelNumber) && !(is_int($parcelNumber) || ctype_digit($parcelNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelNumber, true), gettype($parcelNumber)), __LINE__);
        }
        $this->ParcelNumber = $parcelNumber;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ParcelResponse
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get BarcodeContent value
     * @return string|null
     */
    public function getBarcodeContent()
    {
        return $this->BarcodeContent;
    }
    /**
     * Set BarcodeContent value
     * @param string $barcodeContent
     * @return \StructType\ParcelResponse
     */
    public function setBarcodeContent($barcodeContent = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeContent) && !is_string($barcodeContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeContent, true), gettype($barcodeContent)), __LINE__);
        }
        $this->BarcodeContent = $barcodeContent;
        return $this;
    }
    /**
     * Get ParcelUPI value
     * @return string|null
     */
    public function getParcelUPI()
    {
        return $this->ParcelUPI;
    }
    /**
     * Set ParcelUPI value
     * @param string $parcelUPI
     * @return \StructType\ParcelResponse
     */
    public function setParcelUPI($parcelUPI = null)
    {
        // validation for constraint: string
        if (!is_null($parcelUPI) && !is_string($parcelUPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcelUPI, true), gettype($parcelUPI)), __LINE__);
        }
        $this->ParcelUPI = $parcelUPI;
        return $this;
    }
    /**
     * Get TrackingUrl value
     * @return string|null
     */
    public function getTrackingUrl()
    {
        return $this->TrackingUrl;
    }
    /**
     * Set TrackingUrl value
     * @param string $trackingUrl
     * @return \StructType\ParcelResponse
     */
    public function setTrackingUrl($trackingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($trackingUrl) && !is_string($trackingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingUrl, true), gettype($trackingUrl)), __LINE__);
        }
        $this->TrackingUrl = $trackingUrl;
        return $this;
    }
}
