<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcel StructType
 * @subpackage Structs
 */
class Parcel extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Number;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Weight;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Width;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The Depth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Depth;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Height;
    /**
     * The LargestArea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LargestArea;
    /**
     * The LargestVolumeItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LargestVolumeItem;
    /**
     * The LongestAreaItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LongestAreaItem;
    /**
     * The LongestDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LongestDimension;
    /**
     * The LongestDimensionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LongestDimensionItem;
    /**
     * The LongestSumDimensions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LongestSumDimensions;
    /**
     * The LongestSumItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LongestSumItem;
    /**
     * The ParcelProducts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParcelProduct
     */
    public $ParcelProducts;
    /**
     * The UniqueParcelIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueParcelIdentifier;
    /**
     * Constructor method for parcel
     * @uses Parcel::setNumber()
     * @uses Parcel::setValue()
     * @uses Parcel::setWeight()
     * @uses Parcel::setWidth()
     * @uses Parcel::setExtensionData()
     * @uses Parcel::setDepth()
     * @uses Parcel::setHeight()
     * @uses Parcel::setLargestArea()
     * @uses Parcel::setLargestVolumeItem()
     * @uses Parcel::setLongestAreaItem()
     * @uses Parcel::setLongestDimension()
     * @uses Parcel::setLongestDimensionItem()
     * @uses Parcel::setLongestSumDimensions()
     * @uses Parcel::setLongestSumItem()
     * @uses Parcel::setParcelProducts()
     * @uses Parcel::setUniqueParcelIdentifier()
     * @param int $number
     * @param float $value
     * @param float $weight
     * @param float $width
     * @param \StructType\ExtensionDataObject $extensionData
     * @param float $depth
     * @param float $height
     * @param float $largestArea
     * @param float $largestVolumeItem
     * @param float $longestAreaItem
     * @param float $longestDimension
     * @param float $longestDimensionItem
     * @param float $longestSumDimensions
     * @param float $longestSumItem
     * @param \ArrayType\ArrayOfParcelProduct $parcelProducts
     * @param string $uniqueParcelIdentifier
     */
    public function __construct($number = null, $value = null, $weight = null, $width = null, \StructType\ExtensionDataObject $extensionData = null, $depth = null, $height = null, $largestArea = null, $largestVolumeItem = null, $longestAreaItem = null, $longestDimension = null, $longestDimensionItem = null, $longestSumDimensions = null, $longestSumItem = null, \ArrayType\ArrayOfParcelProduct $parcelProducts = null, $uniqueParcelIdentifier = null)
    {
        $this
            ->setNumber($number)
            ->setValue($value)
            ->setWeight($weight)
            ->setWidth($width)
            ->setExtensionData($extensionData)
            ->setDepth($depth)
            ->setHeight($height)
            ->setLargestArea($largestArea)
            ->setLargestVolumeItem($largestVolumeItem)
            ->setLongestAreaItem($longestAreaItem)
            ->setLongestDimension($longestDimension)
            ->setLongestDimensionItem($longestDimensionItem)
            ->setLongestSumDimensions($longestSumDimensions)
            ->setLongestSumItem($longestSumItem)
            ->setParcelProducts($parcelProducts)
            ->setUniqueParcelIdentifier($uniqueParcelIdentifier);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\Parcel
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Value value
     * @return float
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\Parcel
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \StructType\Parcel
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get Width value
     * @return float
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\Parcel
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\Parcel
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get Depth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDepth()
    {
        return isset($this->Depth) ? $this->Depth : null;
    }
    /**
     * Set Depth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $depth
     * @return \StructType\Parcel
     */
    public function setDepth($depth = null)
    {
        // validation for constraint: float
        if (!is_null($depth) && !(is_float($depth) || is_numeric($depth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depth, true), gettype($depth)), __LINE__);
        }
        if (is_null($depth) || (is_array($depth) && empty($depth))) {
            unset($this->Depth);
        } else {
            $this->Depth = $depth;
        }
        return $this;
    }
    /**
     * Get Height value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHeight()
    {
        return isset($this->Height) ? $this->Height : null;
    }
    /**
     * Set Height value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $height
     * @return \StructType\Parcel
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        if (is_null($height) || (is_array($height) && empty($height))) {
            unset($this->Height);
        } else {
            $this->Height = $height;
        }
        return $this;
    }
    /**
     * Get LargestArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLargestArea()
    {
        return isset($this->LargestArea) ? $this->LargestArea : null;
    }
    /**
     * Set LargestArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $largestArea
     * @return \StructType\Parcel
     */
    public function setLargestArea($largestArea = null)
    {
        // validation for constraint: float
        if (!is_null($largestArea) && !(is_float($largestArea) || is_numeric($largestArea))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($largestArea, true), gettype($largestArea)), __LINE__);
        }
        if (is_null($largestArea) || (is_array($largestArea) && empty($largestArea))) {
            unset($this->LargestArea);
        } else {
            $this->LargestArea = $largestArea;
        }
        return $this;
    }
    /**
     * Get LargestVolumeItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLargestVolumeItem()
    {
        return isset($this->LargestVolumeItem) ? $this->LargestVolumeItem : null;
    }
    /**
     * Set LargestVolumeItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $largestVolumeItem
     * @return \StructType\Parcel
     */
    public function setLargestVolumeItem($largestVolumeItem = null)
    {
        // validation for constraint: float
        if (!is_null($largestVolumeItem) && !(is_float($largestVolumeItem) || is_numeric($largestVolumeItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($largestVolumeItem, true), gettype($largestVolumeItem)), __LINE__);
        }
        if (is_null($largestVolumeItem) || (is_array($largestVolumeItem) && empty($largestVolumeItem))) {
            unset($this->LargestVolumeItem);
        } else {
            $this->LargestVolumeItem = $largestVolumeItem;
        }
        return $this;
    }
    /**
     * Get LongestAreaItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongestAreaItem()
    {
        return isset($this->LongestAreaItem) ? $this->LongestAreaItem : null;
    }
    /**
     * Set LongestAreaItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longestAreaItem
     * @return \StructType\Parcel
     */
    public function setLongestAreaItem($longestAreaItem = null)
    {
        // validation for constraint: float
        if (!is_null($longestAreaItem) && !(is_float($longestAreaItem) || is_numeric($longestAreaItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longestAreaItem, true), gettype($longestAreaItem)), __LINE__);
        }
        if (is_null($longestAreaItem) || (is_array($longestAreaItem) && empty($longestAreaItem))) {
            unset($this->LongestAreaItem);
        } else {
            $this->LongestAreaItem = $longestAreaItem;
        }
        return $this;
    }
    /**
     * Get LongestDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongestDimension()
    {
        return isset($this->LongestDimension) ? $this->LongestDimension : null;
    }
    /**
     * Set LongestDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longestDimension
     * @return \StructType\Parcel
     */
    public function setLongestDimension($longestDimension = null)
    {
        // validation for constraint: float
        if (!is_null($longestDimension) && !(is_float($longestDimension) || is_numeric($longestDimension))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longestDimension, true), gettype($longestDimension)), __LINE__);
        }
        if (is_null($longestDimension) || (is_array($longestDimension) && empty($longestDimension))) {
            unset($this->LongestDimension);
        } else {
            $this->LongestDimension = $longestDimension;
        }
        return $this;
    }
    /**
     * Get LongestDimensionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongestDimensionItem()
    {
        return isset($this->LongestDimensionItem) ? $this->LongestDimensionItem : null;
    }
    /**
     * Set LongestDimensionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longestDimensionItem
     * @return \StructType\Parcel
     */
    public function setLongestDimensionItem($longestDimensionItem = null)
    {
        // validation for constraint: float
        if (!is_null($longestDimensionItem) && !(is_float($longestDimensionItem) || is_numeric($longestDimensionItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longestDimensionItem, true), gettype($longestDimensionItem)), __LINE__);
        }
        if (is_null($longestDimensionItem) || (is_array($longestDimensionItem) && empty($longestDimensionItem))) {
            unset($this->LongestDimensionItem);
        } else {
            $this->LongestDimensionItem = $longestDimensionItem;
        }
        return $this;
    }
    /**
     * Get LongestSumDimensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongestSumDimensions()
    {
        return isset($this->LongestSumDimensions) ? $this->LongestSumDimensions : null;
    }
    /**
     * Set LongestSumDimensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longestSumDimensions
     * @return \StructType\Parcel
     */
    public function setLongestSumDimensions($longestSumDimensions = null)
    {
        // validation for constraint: float
        if (!is_null($longestSumDimensions) && !(is_float($longestSumDimensions) || is_numeric($longestSumDimensions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longestSumDimensions, true), gettype($longestSumDimensions)), __LINE__);
        }
        if (is_null($longestSumDimensions) || (is_array($longestSumDimensions) && empty($longestSumDimensions))) {
            unset($this->LongestSumDimensions);
        } else {
            $this->LongestSumDimensions = $longestSumDimensions;
        }
        return $this;
    }
    /**
     * Get LongestSumItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLongestSumItem()
    {
        return isset($this->LongestSumItem) ? $this->LongestSumItem : null;
    }
    /**
     * Set LongestSumItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $longestSumItem
     * @return \StructType\Parcel
     */
    public function setLongestSumItem($longestSumItem = null)
    {
        // validation for constraint: float
        if (!is_null($longestSumItem) && !(is_float($longestSumItem) || is_numeric($longestSumItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longestSumItem, true), gettype($longestSumItem)), __LINE__);
        }
        if (is_null($longestSumItem) || (is_array($longestSumItem) && empty($longestSumItem))) {
            unset($this->LongestSumItem);
        } else {
            $this->LongestSumItem = $longestSumItem;
        }
        return $this;
    }
    /**
     * Get ParcelProducts value
     * @return \ArrayType\ArrayOfParcelProduct|null
     */
    public function getParcelProducts()
    {
        return $this->ParcelProducts;
    }
    /**
     * Set ParcelProducts value
     * @param \ArrayType\ArrayOfParcelProduct $parcelProducts
     * @return \StructType\Parcel
     */
    public function setParcelProducts(\ArrayType\ArrayOfParcelProduct $parcelProducts = null)
    {
        $this->ParcelProducts = $parcelProducts;
        return $this;
    }
    /**
     * Get UniqueParcelIdentifier value
     * @return string|null
     */
    public function getUniqueParcelIdentifier()
    {
        return $this->UniqueParcelIdentifier;
    }
    /**
     * Set UniqueParcelIdentifier value
     * @param string $uniqueParcelIdentifier
     * @return \StructType\Parcel
     */
    public function setUniqueParcelIdentifier($uniqueParcelIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueParcelIdentifier) && !is_string($uniqueParcelIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueParcelIdentifier, true), gettype($uniqueParcelIdentifier)), __LINE__);
        }
        $this->UniqueParcelIdentifier = $uniqueParcelIdentifier;
        return $this;
    }
}
