<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportOrders StructType
 * @subpackage Structs
 */
class ImportOrders extends AbstractStructBase
{
    /**
     * The importTemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $importTemplateId;
    /**
     * The clientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientCode;
    /**
     * The fileContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fileContent;
    /**
     * The originalFileName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $originalFileName;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * Constructor method for ImportOrders
     * @uses ImportOrders::setImportTemplateId()
     * @uses ImportOrders::setClientCode()
     * @uses ImportOrders::setFileContent()
     * @uses ImportOrders::setOriginalFileName()
     * @uses ImportOrders::setUserName()
     * @param int $importTemplateId
     * @param string $clientCode
     * @param string $fileContent
     * @param string $originalFileName
     * @param string $userName
     */
    public function __construct($importTemplateId = null, $clientCode = null, $fileContent = null, $originalFileName = null, $userName = null)
    {
        $this
            ->setImportTemplateId($importTemplateId)
            ->setClientCode($clientCode)
            ->setFileContent($fileContent)
            ->setOriginalFileName($originalFileName)
            ->setUserName($userName);
    }
    /**
     * Get importTemplateId value
     * @return int
     */
    public function getImportTemplateId()
    {
        return $this->importTemplateId;
    }
    /**
     * Set importTemplateId value
     * @param int $importTemplateId
     * @return \StructType\ImportOrders
     */
    public function setImportTemplateId($importTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($importTemplateId) && !(is_int($importTemplateId) || ctype_digit($importTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importTemplateId, true), gettype($importTemplateId)), __LINE__);
        }
        $this->importTemplateId = $importTemplateId;
        return $this;
    }
    /**
     * Get clientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->clientCode;
    }
    /**
     * Set clientCode value
     * @param string $clientCode
     * @return \StructType\ImportOrders
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->clientCode = $clientCode;
        return $this;
    }
    /**
     * Get fileContent value
     * @return string|null
     */
    public function getFileContent()
    {
        return $this->fileContent;
    }
    /**
     * Set fileContent value
     * @param string $fileContent
     * @return \StructType\ImportOrders
     */
    public function setFileContent($fileContent = null)
    {
        // validation for constraint: string
        if (!is_null($fileContent) && !is_string($fileContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileContent, true), gettype($fileContent)), __LINE__);
        }
        $this->fileContent = $fileContent;
        return $this;
    }
    /**
     * Get originalFileName value
     * @return string|null
     */
    public function getOriginalFileName()
    {
        return $this->originalFileName;
    }
    /**
     * Set originalFileName value
     * @param string $originalFileName
     * @return \StructType\ImportOrders
     */
    public function setOriginalFileName($originalFileName = null)
    {
        // validation for constraint: string
        if (!is_null($originalFileName) && !is_string($originalFileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalFileName, true), gettype($originalFileName)), __LINE__);
        }
        $this->originalFileName = $originalFileName;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\ImportOrders
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
}
