<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStoresResponse StructType
 * @subpackage Structs
 */
class GetStoresResponse extends AbstractStructBase
{
    /**
     * The Successful
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Successful;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Stores
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfClickCollectStore
     */
    public $Stores;
    /**
     * The GetStoresResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GetStoresResponse
     */
    public $GetStoresResult;
    /**
     * Constructor method for GetStoresResponse
     * @uses GetStoresResponse::setSuccessful()
     * @uses GetStoresResponse::setExtensionData()
     * @uses GetStoresResponse::setErrorMessage()
     * @uses GetStoresResponse::setStores()
     * @uses GetStoresResponse::setGetStoresResult()
     * @param bool $successful
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $errorMessage
     * @param \ArrayType\ArrayOfClickCollectStore $stores
     * @param \StructType\GetStoresResponse $getStoresResult
     */
    public function __construct($successful = null, \StructType\ExtensionDataObject $extensionData = null, $errorMessage = null, \ArrayType\ArrayOfClickCollectStore $stores = null, \StructType\GetStoresResponse $getStoresResult = null)
    {
        $this
            ->setSuccessful($successful)
            ->setExtensionData($extensionData)
            ->setErrorMessage($errorMessage)
            ->setStores($stores)
            ->setGetStoresResult($getStoresResult);
    }
    /**
     * Get Successful value
     * @return bool
     */
    public function getSuccessful()
    {
        return $this->Successful;
    }
    /**
     * Set Successful value
     * @param bool $successful
     * @return \StructType\GetStoresResponse
     */
    public function setSuccessful($successful = null)
    {
        // validation for constraint: boolean
        if (!is_null($successful) && !is_bool($successful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($successful, true), gettype($successful)), __LINE__);
        }
        $this->Successful = $successful;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\GetStoresResponse
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\GetStoresResponse
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Stores value
     * @return \ArrayType\ArrayOfClickCollectStore|null
     */
    public function getStores()
    {
        return $this->Stores;
    }
    /**
     * Set Stores value
     * @param \ArrayType\ArrayOfClickCollectStore $stores
     * @return \StructType\GetStoresResponse
     */
    public function setStores(\ArrayType\ArrayOfClickCollectStore $stores = null)
    {
        $this->Stores = $stores;
        return $this;
    }
    /**
     * Get GetStoresResult value
     * @return \StructType\GetStoresResponse|null
     */
    public function getGetStoresResult()
    {
        return $this->GetStoresResult;
    }
    /**
     * Set GetStoresResult value
     * @param \StructType\GetStoresResponse $getStoresResult
     * @return \StructType\GetStoresResponse
     */
    public function setGetStoresResult(\StructType\GetStoresResponse $getStoresResult = null)
    {
        $this->GetStoresResult = $getStoresResult;
        return $this;
    }
}
