<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDespatchDetailsRequest StructType
 * @subpackage Structs
 */
class GetDespatchDetailsRequest extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientSiteOrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSiteOrderReference;
    /**
     * Constructor method for GetDespatchDetailsRequest
     * @uses GetDespatchDetailsRequest::setExtensionData()
     * @uses GetDespatchDetailsRequest::setClientCode()
     * @uses GetDespatchDetailsRequest::setClientSiteOrderReference()
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $clientCode
     * @param string $clientSiteOrderReference
     */
    public function __construct(\StructType\ExtensionDataObject $extensionData = null, $clientCode = null, $clientSiteOrderReference = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setClientCode($clientCode)
            ->setClientSiteOrderReference($clientSiteOrderReference);
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\GetDespatchDetailsRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\GetDespatchDetailsRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ClientSiteOrderReference value
     * @return string|null
     */
    public function getClientSiteOrderReference()
    {
        return $this->ClientSiteOrderReference;
    }
    /**
     * Set ClientSiteOrderReference value
     * @param string $clientSiteOrderReference
     * @return \StructType\GetDespatchDetailsRequest
     */
    public function setClientSiteOrderReference($clientSiteOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderReference) && !is_string($clientSiteOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderReference, true), gettype($clientSiteOrderReference)), __LINE__);
        }
        $this->ClientSiteOrderReference = $clientSiteOrderReference;
        return $this;
    }
}
