<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExportTrackingRequest StructType
 * @subpackage Structs
 */
class ExportTrackingRequest extends AbstractStructBase
{
    /**
     * The DaysCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DaysCount;
    /**
     * The EventCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EventCount;
    /**
     * The ExportId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExportId;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * Constructor method for ExportTrackingRequest
     * @uses ExportTrackingRequest::setDaysCount()
     * @uses ExportTrackingRequest::setEventCount()
     * @uses ExportTrackingRequest::setExportId()
     * @uses ExportTrackingRequest::setExtensionData()
     * @uses ExportTrackingRequest::setCarrierCode()
     * @uses ExportTrackingRequest::setClientCode()
     * @param int $daysCount
     * @param int $eventCount
     * @param int $exportId
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $clientCode
     */
    public function __construct($daysCount = null, $eventCount = null, $exportId = null, \StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $clientCode = null)
    {
        $this
            ->setDaysCount($daysCount)
            ->setEventCount($eventCount)
            ->setExportId($exportId)
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setClientCode($clientCode);
    }
    /**
     * Get DaysCount value
     * @return int
     */
    public function getDaysCount()
    {
        return $this->DaysCount;
    }
    /**
     * Set DaysCount value
     * @param int $daysCount
     * @return \StructType\ExportTrackingRequest
     */
    public function setDaysCount($daysCount = null)
    {
        // validation for constraint: int
        if (!is_null($daysCount) && !(is_int($daysCount) || ctype_digit($daysCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysCount, true), gettype($daysCount)), __LINE__);
        }
        $this->DaysCount = $daysCount;
        return $this;
    }
    /**
     * Get EventCount value
     * @return int
     */
    public function getEventCount()
    {
        return $this->EventCount;
    }
    /**
     * Set EventCount value
     * @param int $eventCount
     * @return \StructType\ExportTrackingRequest
     */
    public function setEventCount($eventCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventCount) && !(is_int($eventCount) || ctype_digit($eventCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCount, true), gettype($eventCount)), __LINE__);
        }
        $this->EventCount = $eventCount;
        return $this;
    }
    /**
     * Get ExportId value
     * @return int
     */
    public function getExportId()
    {
        return $this->ExportId;
    }
    /**
     * Set ExportId value
     * @param int $exportId
     * @return \StructType\ExportTrackingRequest
     */
    public function setExportId($exportId = null)
    {
        // validation for constraint: int
        if (!is_null($exportId) && !(is_int($exportId) || ctype_digit($exportId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exportId, true), gettype($exportId)), __LINE__);
        }
        $this->ExportId = $exportId;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ExportTrackingRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\ExportTrackingRequest
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\ExportTrackingRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
}
