<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiagnosticsSpeedTest StructType
 * @subpackage Structs
 */
class DiagnosticsSpeedTest extends AbstractStructBase
{
    /**
     * The DatabaseCallsPerSecond
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DatabaseCallsPerSecond;
    /**
     * The WcfLayerCallsPerSecond
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $WcfLayerCallsPerSecond;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * Constructor method for DiagnosticsSpeedTest
     * @uses DiagnosticsSpeedTest::setDatabaseCallsPerSecond()
     * @uses DiagnosticsSpeedTest::setWcfLayerCallsPerSecond()
     * @uses DiagnosticsSpeedTest::setExtensionData()
     * @uses DiagnosticsSpeedTest::setErrorMessage()
     * @param int $databaseCallsPerSecond
     * @param int $wcfLayerCallsPerSecond
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $errorMessage
     */
    public function __construct($databaseCallsPerSecond = null, $wcfLayerCallsPerSecond = null, \StructType\ExtensionDataObject $extensionData = null, $errorMessage = null)
    {
        $this
            ->setDatabaseCallsPerSecond($databaseCallsPerSecond)
            ->setWcfLayerCallsPerSecond($wcfLayerCallsPerSecond)
            ->setExtensionData($extensionData)
            ->setErrorMessage($errorMessage);
    }
    /**
     * Get DatabaseCallsPerSecond value
     * @return int
     */
    public function getDatabaseCallsPerSecond()
    {
        return $this->DatabaseCallsPerSecond;
    }
    /**
     * Set DatabaseCallsPerSecond value
     * @param int $databaseCallsPerSecond
     * @return \StructType\DiagnosticsSpeedTest
     */
    public function setDatabaseCallsPerSecond($databaseCallsPerSecond = null)
    {
        // validation for constraint: int
        if (!is_null($databaseCallsPerSecond) && !(is_int($databaseCallsPerSecond) || ctype_digit($databaseCallsPerSecond))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($databaseCallsPerSecond, true), gettype($databaseCallsPerSecond)), __LINE__);
        }
        $this->DatabaseCallsPerSecond = $databaseCallsPerSecond;
        return $this;
    }
    /**
     * Get WcfLayerCallsPerSecond value
     * @return int
     */
    public function getWcfLayerCallsPerSecond()
    {
        return $this->WcfLayerCallsPerSecond;
    }
    /**
     * Set WcfLayerCallsPerSecond value
     * @param int $wcfLayerCallsPerSecond
     * @return \StructType\DiagnosticsSpeedTest
     */
    public function setWcfLayerCallsPerSecond($wcfLayerCallsPerSecond = null)
    {
        // validation for constraint: int
        if (!is_null($wcfLayerCallsPerSecond) && !(is_int($wcfLayerCallsPerSecond) || ctype_digit($wcfLayerCallsPerSecond))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wcfLayerCallsPerSecond, true), gettype($wcfLayerCallsPerSecond)), __LINE__);
        }
        $this->WcfLayerCallsPerSecond = $wcfLayerCallsPerSecond;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\DiagnosticsSpeedTest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\DiagnosticsSpeedTest
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
}
