<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiagnosticsFull StructType
 * @subpackage Structs
 */
class DiagnosticsFull extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The DatabaseConnectionString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabaseConnectionString;
    /**
     * The DatabaseVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabaseVersion;
    /**
     * The Endpoint
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Endpoint;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Version;
    /**
     * Constructor method for DiagnosticsFull
     * @uses DiagnosticsFull::setExtensionData()
     * @uses DiagnosticsFull::setDatabaseConnectionString()
     * @uses DiagnosticsFull::setDatabaseVersion()
     * @uses DiagnosticsFull::setEndpoint()
     * @uses DiagnosticsFull::setErrorMessage()
     * @uses DiagnosticsFull::setVersion()
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $databaseConnectionString
     * @param string $databaseVersion
     * @param string $endpoint
     * @param string $errorMessage
     * @param string $version
     */
    public function __construct(\StructType\ExtensionDataObject $extensionData = null, $databaseConnectionString = null, $databaseVersion = null, $endpoint = null, $errorMessage = null, $version = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setDatabaseConnectionString($databaseConnectionString)
            ->setDatabaseVersion($databaseVersion)
            ->setEndpoint($endpoint)
            ->setErrorMessage($errorMessage)
            ->setVersion($version);
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\DiagnosticsFull
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get DatabaseConnectionString value
     * @return string|null
     */
    public function getDatabaseConnectionString()
    {
        return $this->DatabaseConnectionString;
    }
    /**
     * Set DatabaseConnectionString value
     * @param string $databaseConnectionString
     * @return \StructType\DiagnosticsFull
     */
    public function setDatabaseConnectionString($databaseConnectionString = null)
    {
        // validation for constraint: string
        if (!is_null($databaseConnectionString) && !is_string($databaseConnectionString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseConnectionString, true), gettype($databaseConnectionString)), __LINE__);
        }
        $this->DatabaseConnectionString = $databaseConnectionString;
        return $this;
    }
    /**
     * Get DatabaseVersion value
     * @return string|null
     */
    public function getDatabaseVersion()
    {
        return $this->DatabaseVersion;
    }
    /**
     * Set DatabaseVersion value
     * @param string $databaseVersion
     * @return \StructType\DiagnosticsFull
     */
    public function setDatabaseVersion($databaseVersion = null)
    {
        // validation for constraint: string
        if (!is_null($databaseVersion) && !is_string($databaseVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($databaseVersion, true), gettype($databaseVersion)), __LINE__);
        }
        $this->DatabaseVersion = $databaseVersion;
        return $this;
    }
    /**
     * Get Endpoint value
     * @return string|null
     */
    public function getEndpoint()
    {
        return $this->Endpoint;
    }
    /**
     * Set Endpoint value
     * @param string $endpoint
     * @return \StructType\DiagnosticsFull
     */
    public function setEndpoint($endpoint = null)
    {
        // validation for constraint: string
        if (!is_null($endpoint) && !is_string($endpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endpoint, true), gettype($endpoint)), __LINE__);
        }
        $this->Endpoint = $endpoint;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \StructType\DiagnosticsFull
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\DiagnosticsFull
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
}
