<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DespatchBaseRequest StructType
 * @subpackage Structs
 */
class DespatchBaseRequest extends AbstractStructBase
{
    /**
     * The AdditionalCompensation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AdditionalCompensation;
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine3;
    /**
     * The AddressLine4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine4;
    /**
     * The Aerosol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Aerosol;
    /**
     * The Compensation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Compensation;
    /**
     * The Fragile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Fragile;
    /**
     * The Hazardous
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Hazardous;
    /**
     * The IsReturnsOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReturnsOrder;
    /**
     * The Liquid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Liquid;
    /**
     * The MaxHeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxHeight;
    /**
     * The MaxItemWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxItemWeight;
    /**
     * The MaxLength
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxLength;
    /**
     * The MaxLengthSum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxLengthSum;
    /**
     * The MaxParcelWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxParcelWeight;
    /**
     * The MaxWidth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $MaxWidth;
    /**
     * The OrderValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OrderValue;
    /**
     * The OrderVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OrderVolume;
    /**
     * The OrderWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $OrderWeight;
    /**
     * The PalletDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $PalletDelivery;
    /**
     * The ProofOfDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ProofOfDelivery;
    /**
     * The TwoManLift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $TwoManLift;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientDespatchMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientDespatchMethod;
    /**
     * The ClientDespatchService
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientDespatchService;
    /**
     * The ClientSiteOrderReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientSiteOrderReference;
    /**
     * The CollectPlusStoreID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CollectPlusStoreID;
    /**
     * The CollectionStoreID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CollectionStoreID;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryName;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The CustomerType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerType;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryPointCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryPointCode;
    /**
     * The DeliveryToEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryToEmail;
    /**
     * The DeliveryToMobilePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryToMobilePhone;
    /**
     * The DeliveryToName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryToName;
    /**
     * The DeliveryToPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryToPhone;
    /**
     * The DespatchDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DespatchDate;
    /**
     * The EORI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EORI;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The HouseholdSignature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HouseholdSignature;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The OrderNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderNumber;
    /**
     * The RetailValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RetailValue;
    /**
     * The ReturnAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddressRequest
     */
    public $ReturnAddress;
    /**
     * The Site
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Site;
    /**
     * The SpecialInstruction1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SpecialInstruction1;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The VerboseMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VerboseMode;
    /**
     * Constructor method for DespatchBaseRequest
     * @uses DespatchBaseRequest::setAdditionalCompensation()
     * @uses DespatchBaseRequest::setAddressLine1()
     * @uses DespatchBaseRequest::setAddressLine2()
     * @uses DespatchBaseRequest::setAddressLine3()
     * @uses DespatchBaseRequest::setAddressLine4()
     * @uses DespatchBaseRequest::setAerosol()
     * @uses DespatchBaseRequest::setCompensation()
     * @uses DespatchBaseRequest::setFragile()
     * @uses DespatchBaseRequest::setHazardous()
     * @uses DespatchBaseRequest::setIsReturnsOrder()
     * @uses DespatchBaseRequest::setLiquid()
     * @uses DespatchBaseRequest::setMaxHeight()
     * @uses DespatchBaseRequest::setMaxItemWeight()
     * @uses DespatchBaseRequest::setMaxLength()
     * @uses DespatchBaseRequest::setMaxLengthSum()
     * @uses DespatchBaseRequest::setMaxParcelWeight()
     * @uses DespatchBaseRequest::setMaxWidth()
     * @uses DespatchBaseRequest::setOrderValue()
     * @uses DespatchBaseRequest::setOrderVolume()
     * @uses DespatchBaseRequest::setOrderWeight()
     * @uses DespatchBaseRequest::setPalletDelivery()
     * @uses DespatchBaseRequest::setProofOfDelivery()
     * @uses DespatchBaseRequest::setTwoManLift()
     * @uses DespatchBaseRequest::setExtensionData()
     * @uses DespatchBaseRequest::setClientCode()
     * @uses DespatchBaseRequest::setClientDespatchMethod()
     * @uses DespatchBaseRequest::setClientDespatchService()
     * @uses DespatchBaseRequest::setClientSiteOrderReference()
     * @uses DespatchBaseRequest::setCollectPlusStoreID()
     * @uses DespatchBaseRequest::setCollectionStoreID()
     * @uses DespatchBaseRequest::setCompanyName()
     * @uses DespatchBaseRequest::setCountryCode()
     * @uses DespatchBaseRequest::setCountryName()
     * @uses DespatchBaseRequest::setCurrency()
     * @uses DespatchBaseRequest::setCustomerType()
     * @uses DespatchBaseRequest::setDeliveryDate()
     * @uses DespatchBaseRequest::setDeliveryPointCode()
     * @uses DespatchBaseRequest::setDeliveryToEmail()
     * @uses DespatchBaseRequest::setDeliveryToMobilePhone()
     * @uses DespatchBaseRequest::setDeliveryToName()
     * @uses DespatchBaseRequest::setDeliveryToPhone()
     * @uses DespatchBaseRequest::setDespatchDate()
     * @uses DespatchBaseRequest::setEORI()
     * @uses DespatchBaseRequest::setFirstName()
     * @uses DespatchBaseRequest::setHouseholdSignature()
     * @uses DespatchBaseRequest::setLastName()
     * @uses DespatchBaseRequest::setOrderNumber()
     * @uses DespatchBaseRequest::setRetailValue()
     * @uses DespatchBaseRequest::setReturnAddress()
     * @uses DespatchBaseRequest::setSite()
     * @uses DespatchBaseRequest::setSpecialInstruction1()
     * @uses DespatchBaseRequest::setTitle()
     * @uses DespatchBaseRequest::setVerboseMode()
     * @param bool $additionalCompensation
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $addressLine4
     * @param bool $aerosol
     * @param bool $compensation
     * @param bool $fragile
     * @param bool $hazardous
     * @param bool $isReturnsOrder
     * @param bool $liquid
     * @param float $maxHeight
     * @param float $maxItemWeight
     * @param float $maxLength
     * @param float $maxLengthSum
     * @param float $maxParcelWeight
     * @param float $maxWidth
     * @param float $orderValue
     * @param float $orderVolume
     * @param float $orderWeight
     * @param bool $palletDelivery
     * @param bool $proofOfDelivery
     * @param bool $twoManLift
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $clientCode
     * @param string $clientDespatchMethod
     * @param string $clientDespatchService
     * @param string $clientSiteOrderReference
     * @param string $collectPlusStoreID
     * @param string $collectionStoreID
     * @param string $companyName
     * @param string $countryCode
     * @param string $countryName
     * @param string $currency
     * @param string $customerType
     * @param string $deliveryDate
     * @param string $deliveryPointCode
     * @param string $deliveryToEmail
     * @param string $deliveryToMobilePhone
     * @param string $deliveryToName
     * @param string $deliveryToPhone
     * @param string $despatchDate
     * @param string $eORI
     * @param string $firstName
     * @param bool $householdSignature
     * @param string $lastName
     * @param string $orderNumber
     * @param float $retailValue
     * @param \StructType\AddressRequest $returnAddress
     * @param string $site
     * @param string $specialInstruction1
     * @param string $title
     * @param string $verboseMode
     */
    public function __construct($additionalCompensation = null, $addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $addressLine4 = null, $aerosol = null, $compensation = null, $fragile = null, $hazardous = null, $isReturnsOrder = null, $liquid = null, $maxHeight = null, $maxItemWeight = null, $maxLength = null, $maxLengthSum = null, $maxParcelWeight = null, $maxWidth = null, $orderValue = null, $orderVolume = null, $orderWeight = null, $palletDelivery = null, $proofOfDelivery = null, $twoManLift = null, \StructType\ExtensionDataObject $extensionData = null, $clientCode = null, $clientDespatchMethod = null, $clientDespatchService = null, $clientSiteOrderReference = null, $collectPlusStoreID = null, $collectionStoreID = null, $companyName = null, $countryCode = null, $countryName = null, $currency = null, $customerType = null, $deliveryDate = null, $deliveryPointCode = null, $deliveryToEmail = null, $deliveryToMobilePhone = null, $deliveryToName = null, $deliveryToPhone = null, $despatchDate = null, $eORI = null, $firstName = null, $householdSignature = null, $lastName = null, $orderNumber = null, $retailValue = null, \StructType\AddressRequest $returnAddress = null, $site = null, $specialInstruction1 = null, $title = null, $verboseMode = null)
    {
        $this
            ->setAdditionalCompensation($additionalCompensation)
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setAddressLine4($addressLine4)
            ->setAerosol($aerosol)
            ->setCompensation($compensation)
            ->setFragile($fragile)
            ->setHazardous($hazardous)
            ->setIsReturnsOrder($isReturnsOrder)
            ->setLiquid($liquid)
            ->setMaxHeight($maxHeight)
            ->setMaxItemWeight($maxItemWeight)
            ->setMaxLength($maxLength)
            ->setMaxLengthSum($maxLengthSum)
            ->setMaxParcelWeight($maxParcelWeight)
            ->setMaxWidth($maxWidth)
            ->setOrderValue($orderValue)
            ->setOrderVolume($orderVolume)
            ->setOrderWeight($orderWeight)
            ->setPalletDelivery($palletDelivery)
            ->setProofOfDelivery($proofOfDelivery)
            ->setTwoManLift($twoManLift)
            ->setExtensionData($extensionData)
            ->setClientCode($clientCode)
            ->setClientDespatchMethod($clientDespatchMethod)
            ->setClientDespatchService($clientDespatchService)
            ->setClientSiteOrderReference($clientSiteOrderReference)
            ->setCollectPlusStoreID($collectPlusStoreID)
            ->setCollectionStoreID($collectionStoreID)
            ->setCompanyName($companyName)
            ->setCountryCode($countryCode)
            ->setCountryName($countryName)
            ->setCurrency($currency)
            ->setCustomerType($customerType)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryPointCode($deliveryPointCode)
            ->setDeliveryToEmail($deliveryToEmail)
            ->setDeliveryToMobilePhone($deliveryToMobilePhone)
            ->setDeliveryToName($deliveryToName)
            ->setDeliveryToPhone($deliveryToPhone)
            ->setDespatchDate($despatchDate)
            ->setEORI($eORI)
            ->setFirstName($firstName)
            ->setHouseholdSignature($householdSignature)
            ->setLastName($lastName)
            ->setOrderNumber($orderNumber)
            ->setRetailValue($retailValue)
            ->setReturnAddress($returnAddress)
            ->setSite($site)
            ->setSpecialInstruction1($specialInstruction1)
            ->setTitle($title)
            ->setVerboseMode($verboseMode);
    }
    /**
     * Get AdditionalCompensation value
     * @return bool
     */
    public function getAdditionalCompensation()
    {
        return $this->AdditionalCompensation;
    }
    /**
     * Set AdditionalCompensation value
     * @param bool $additionalCompensation
     * @return \StructType\DespatchBaseRequest
     */
    public function setAdditionalCompensation($additionalCompensation = null)
    {
        // validation for constraint: boolean
        if (!is_null($additionalCompensation) && !is_bool($additionalCompensation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($additionalCompensation, true), gettype($additionalCompensation)), __LINE__);
        }
        $this->AdditionalCompensation = $additionalCompensation;
        return $this;
    }
    /**
     * Get AddressLine1 value
     * @return string
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\DespatchBaseRequest
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\DespatchBaseRequest
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get AddressLine3 value
     * @return string
     */
    public function getAddressLine3()
    {
        return $this->AddressLine3;
    }
    /**
     * Set AddressLine3 value
     * @param string $addressLine3
     * @return \StructType\DespatchBaseRequest
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        $this->AddressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get AddressLine4 value
     * @return string
     */
    public function getAddressLine4()
    {
        return $this->AddressLine4;
    }
    /**
     * Set AddressLine4 value
     * @param string $addressLine4
     * @return \StructType\DespatchBaseRequest
     */
    public function setAddressLine4($addressLine4 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine4) && !is_string($addressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine4, true), gettype($addressLine4)), __LINE__);
        }
        $this->AddressLine4 = $addressLine4;
        return $this;
    }
    /**
     * Get Aerosol value
     * @return bool
     */
    public function getAerosol()
    {
        return $this->Aerosol;
    }
    /**
     * Set Aerosol value
     * @param bool $aerosol
     * @return \StructType\DespatchBaseRequest
     */
    public function setAerosol($aerosol = null)
    {
        // validation for constraint: boolean
        if (!is_null($aerosol) && !is_bool($aerosol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aerosol, true), gettype($aerosol)), __LINE__);
        }
        $this->Aerosol = $aerosol;
        return $this;
    }
    /**
     * Get Compensation value
     * @return bool
     */
    public function getCompensation()
    {
        return $this->Compensation;
    }
    /**
     * Set Compensation value
     * @param bool $compensation
     * @return \StructType\DespatchBaseRequest
     */
    public function setCompensation($compensation = null)
    {
        // validation for constraint: boolean
        if (!is_null($compensation) && !is_bool($compensation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compensation, true), gettype($compensation)), __LINE__);
        }
        $this->Compensation = $compensation;
        return $this;
    }
    /**
     * Get Fragile value
     * @return bool
     */
    public function getFragile()
    {
        return $this->Fragile;
    }
    /**
     * Set Fragile value
     * @param bool $fragile
     * @return \StructType\DespatchBaseRequest
     */
    public function setFragile($fragile = null)
    {
        // validation for constraint: boolean
        if (!is_null($fragile) && !is_bool($fragile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fragile, true), gettype($fragile)), __LINE__);
        }
        $this->Fragile = $fragile;
        return $this;
    }
    /**
     * Get Hazardous value
     * @return bool
     */
    public function getHazardous()
    {
        return $this->Hazardous;
    }
    /**
     * Set Hazardous value
     * @param bool $hazardous
     * @return \StructType\DespatchBaseRequest
     */
    public function setHazardous($hazardous = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardous) && !is_bool($hazardous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hazardous, true), gettype($hazardous)), __LINE__);
        }
        $this->Hazardous = $hazardous;
        return $this;
    }
    /**
     * Get IsReturnsOrder value
     * @return bool
     */
    public function getIsReturnsOrder()
    {
        return $this->IsReturnsOrder;
    }
    /**
     * Set IsReturnsOrder value
     * @param bool $isReturnsOrder
     * @return \StructType\DespatchBaseRequest
     */
    public function setIsReturnsOrder($isReturnsOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturnsOrder) && !is_bool($isReturnsOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturnsOrder, true), gettype($isReturnsOrder)), __LINE__);
        }
        $this->IsReturnsOrder = $isReturnsOrder;
        return $this;
    }
    /**
     * Get Liquid value
     * @return bool
     */
    public function getLiquid()
    {
        return $this->Liquid;
    }
    /**
     * Set Liquid value
     * @param bool $liquid
     * @return \StructType\DespatchBaseRequest
     */
    public function setLiquid($liquid = null)
    {
        // validation for constraint: boolean
        if (!is_null($liquid) && !is_bool($liquid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($liquid, true), gettype($liquid)), __LINE__);
        }
        $this->Liquid = $liquid;
        return $this;
    }
    /**
     * Get MaxHeight value
     * @return float
     */
    public function getMaxHeight()
    {
        return $this->MaxHeight;
    }
    /**
     * Set MaxHeight value
     * @param float $maxHeight
     * @return \StructType\DespatchBaseRequest
     */
    public function setMaxHeight($maxHeight = null)
    {
        // validation for constraint: float
        if (!is_null($maxHeight) && !(is_float($maxHeight) || is_numeric($maxHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxHeight, true), gettype($maxHeight)), __LINE__);
        }
        $this->MaxHeight = $maxHeight;
        return $this;
    }
    /**
     * Get MaxItemWeight value
     * @return float
     */
    public function getMaxItemWeight()
    {
        return $this->MaxItemWeight;
    }
    /**
     * Set MaxItemWeight value
     * @param float $maxItemWeight
     * @return \StructType\DespatchBaseRequest
     */
    public function setMaxItemWeight($maxItemWeight = null)
    {
        // validation for constraint: float
        if (!is_null($maxItemWeight) && !(is_float($maxItemWeight) || is_numeric($maxItemWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxItemWeight, true), gettype($maxItemWeight)), __LINE__);
        }
        $this->MaxItemWeight = $maxItemWeight;
        return $this;
    }
    /**
     * Get MaxLength value
     * @return float
     */
    public function getMaxLength()
    {
        return $this->MaxLength;
    }
    /**
     * Set MaxLength value
     * @param float $maxLength
     * @return \StructType\DespatchBaseRequest
     */
    public function setMaxLength($maxLength = null)
    {
        // validation for constraint: float
        if (!is_null($maxLength) && !(is_float($maxLength) || is_numeric($maxLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxLength, true), gettype($maxLength)), __LINE__);
        }
        $this->MaxLength = $maxLength;
        return $this;
    }
    /**
     * Get MaxLengthSum value
     * @return float
     */
    public function getMaxLengthSum()
    {
        return $this->MaxLengthSum;
    }
    /**
     * Set MaxLengthSum value
     * @param float $maxLengthSum
     * @return \StructType\DespatchBaseRequest
     */
    public function setMaxLengthSum($maxLengthSum = null)
    {
        // validation for constraint: float
        if (!is_null($maxLengthSum) && !(is_float($maxLengthSum) || is_numeric($maxLengthSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxLengthSum, true), gettype($maxLengthSum)), __LINE__);
        }
        $this->MaxLengthSum = $maxLengthSum;
        return $this;
    }
    /**
     * Get MaxParcelWeight value
     * @return float
     */
    public function getMaxParcelWeight()
    {
        return $this->MaxParcelWeight;
    }
    /**
     * Set MaxParcelWeight value
     * @param float $maxParcelWeight
     * @return \StructType\DespatchBaseRequest
     */
    public function setMaxParcelWeight($maxParcelWeight = null)
    {
        // validation for constraint: float
        if (!is_null($maxParcelWeight) && !(is_float($maxParcelWeight) || is_numeric($maxParcelWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxParcelWeight, true), gettype($maxParcelWeight)), __LINE__);
        }
        $this->MaxParcelWeight = $maxParcelWeight;
        return $this;
    }
    /**
     * Get MaxWidth value
     * @return float
     */
    public function getMaxWidth()
    {
        return $this->MaxWidth;
    }
    /**
     * Set MaxWidth value
     * @param float $maxWidth
     * @return \StructType\DespatchBaseRequest
     */
    public function setMaxWidth($maxWidth = null)
    {
        // validation for constraint: float
        if (!is_null($maxWidth) && !(is_float($maxWidth) || is_numeric($maxWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxWidth, true), gettype($maxWidth)), __LINE__);
        }
        $this->MaxWidth = $maxWidth;
        return $this;
    }
    /**
     * Get OrderValue value
     * @return float
     */
    public function getOrderValue()
    {
        return $this->OrderValue;
    }
    /**
     * Set OrderValue value
     * @param float $orderValue
     * @return \StructType\DespatchBaseRequest
     */
    public function setOrderValue($orderValue = null)
    {
        // validation for constraint: float
        if (!is_null($orderValue) && !(is_float($orderValue) || is_numeric($orderValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderValue, true), gettype($orderValue)), __LINE__);
        }
        $this->OrderValue = $orderValue;
        return $this;
    }
    /**
     * Get OrderVolume value
     * @return float
     */
    public function getOrderVolume()
    {
        return $this->OrderVolume;
    }
    /**
     * Set OrderVolume value
     * @param float $orderVolume
     * @return \StructType\DespatchBaseRequest
     */
    public function setOrderVolume($orderVolume = null)
    {
        // validation for constraint: float
        if (!is_null($orderVolume) && !(is_float($orderVolume) || is_numeric($orderVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderVolume, true), gettype($orderVolume)), __LINE__);
        }
        $this->OrderVolume = $orderVolume;
        return $this;
    }
    /**
     * Get OrderWeight value
     * @return float
     */
    public function getOrderWeight()
    {
        return $this->OrderWeight;
    }
    /**
     * Set OrderWeight value
     * @param float $orderWeight
     * @return \StructType\DespatchBaseRequest
     */
    public function setOrderWeight($orderWeight = null)
    {
        // validation for constraint: float
        if (!is_null($orderWeight) && !(is_float($orderWeight) || is_numeric($orderWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderWeight, true), gettype($orderWeight)), __LINE__);
        }
        $this->OrderWeight = $orderWeight;
        return $this;
    }
    /**
     * Get PalletDelivery value
     * @return bool
     */
    public function getPalletDelivery()
    {
        return $this->PalletDelivery;
    }
    /**
     * Set PalletDelivery value
     * @param bool $palletDelivery
     * @return \StructType\DespatchBaseRequest
     */
    public function setPalletDelivery($palletDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($palletDelivery) && !is_bool($palletDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($palletDelivery, true), gettype($palletDelivery)), __LINE__);
        }
        $this->PalletDelivery = $palletDelivery;
        return $this;
    }
    /**
     * Get ProofOfDelivery value
     * @return bool
     */
    public function getProofOfDelivery()
    {
        return $this->ProofOfDelivery;
    }
    /**
     * Set ProofOfDelivery value
     * @param bool $proofOfDelivery
     * @return \StructType\DespatchBaseRequest
     */
    public function setProofOfDelivery($proofOfDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($proofOfDelivery) && !is_bool($proofOfDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($proofOfDelivery, true), gettype($proofOfDelivery)), __LINE__);
        }
        $this->ProofOfDelivery = $proofOfDelivery;
        return $this;
    }
    /**
     * Get TwoManLift value
     * @return bool
     */
    public function getTwoManLift()
    {
        return $this->TwoManLift;
    }
    /**
     * Set TwoManLift value
     * @param bool $twoManLift
     * @return \StructType\DespatchBaseRequest
     */
    public function setTwoManLift($twoManLift = null)
    {
        // validation for constraint: boolean
        if (!is_null($twoManLift) && !is_bool($twoManLift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($twoManLift, true), gettype($twoManLift)), __LINE__);
        }
        $this->TwoManLift = $twoManLift;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\DespatchBaseRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\DespatchBaseRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ClientDespatchMethod value
     * @return string|null
     */
    public function getClientDespatchMethod()
    {
        return $this->ClientDespatchMethod;
    }
    /**
     * Set ClientDespatchMethod value
     * @param string $clientDespatchMethod
     * @return \StructType\DespatchBaseRequest
     */
    public function setClientDespatchMethod($clientDespatchMethod = null)
    {
        // validation for constraint: string
        if (!is_null($clientDespatchMethod) && !is_string($clientDespatchMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDespatchMethod, true), gettype($clientDespatchMethod)), __LINE__);
        }
        $this->ClientDespatchMethod = $clientDespatchMethod;
        return $this;
    }
    /**
     * Get ClientDespatchService value
     * @return string|null
     */
    public function getClientDespatchService()
    {
        return $this->ClientDespatchService;
    }
    /**
     * Set ClientDespatchService value
     * @param string $clientDespatchService
     * @return \StructType\DespatchBaseRequest
     */
    public function setClientDespatchService($clientDespatchService = null)
    {
        // validation for constraint: string
        if (!is_null($clientDespatchService) && !is_string($clientDespatchService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDespatchService, true), gettype($clientDespatchService)), __LINE__);
        }
        $this->ClientDespatchService = $clientDespatchService;
        return $this;
    }
    /**
     * Get ClientSiteOrderReference value
     * @return string|null
     */
    public function getClientSiteOrderReference()
    {
        return $this->ClientSiteOrderReference;
    }
    /**
     * Set ClientSiteOrderReference value
     * @param string $clientSiteOrderReference
     * @return \StructType\DespatchBaseRequest
     */
    public function setClientSiteOrderReference($clientSiteOrderReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientSiteOrderReference) && !is_string($clientSiteOrderReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientSiteOrderReference, true), gettype($clientSiteOrderReference)), __LINE__);
        }
        $this->ClientSiteOrderReference = $clientSiteOrderReference;
        return $this;
    }
    /**
     * Get CollectPlusStoreID value
     * @return string|null
     */
    public function getCollectPlusStoreID()
    {
        return $this->CollectPlusStoreID;
    }
    /**
     * Set CollectPlusStoreID value
     * @param string $collectPlusStoreID
     * @return \StructType\DespatchBaseRequest
     */
    public function setCollectPlusStoreID($collectPlusStoreID = null)
    {
        // validation for constraint: string
        if (!is_null($collectPlusStoreID) && !is_string($collectPlusStoreID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectPlusStoreID, true), gettype($collectPlusStoreID)), __LINE__);
        }
        $this->CollectPlusStoreID = $collectPlusStoreID;
        return $this;
    }
    /**
     * Get CollectionStoreID value
     * @return string|null
     */
    public function getCollectionStoreID()
    {
        return $this->CollectionStoreID;
    }
    /**
     * Set CollectionStoreID value
     * @param string $collectionStoreID
     * @return \StructType\DespatchBaseRequest
     */
    public function setCollectionStoreID($collectionStoreID = null)
    {
        // validation for constraint: string
        if (!is_null($collectionStoreID) && !is_string($collectionStoreID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionStoreID, true), gettype($collectionStoreID)), __LINE__);
        }
        $this->CollectionStoreID = $collectionStoreID;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\DespatchBaseRequest
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\DespatchBaseRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CountryName value
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->CountryName;
    }
    /**
     * Set CountryName value
     * @param string $countryName
     * @return \StructType\DespatchBaseRequest
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        $this->CountryName = $countryName;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\DespatchBaseRequest
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param string $customerType
     * @return \StructType\DespatchBaseRequest
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: string
        if (!is_null($customerType) && !is_string($customerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerType, true), gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return isset($this->DeliveryDate) ? $this->DeliveryDate : null;
    }
    /**
     * Set DeliveryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryDate
     * @return \StructType\DespatchBaseRequest
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        if (is_null($deliveryDate) || (is_array($deliveryDate) && empty($deliveryDate))) {
            unset($this->DeliveryDate);
        } else {
            $this->DeliveryDate = $deliveryDate;
        }
        return $this;
    }
    /**
     * Get DeliveryPointCode value
     * @return string|null
     */
    public function getDeliveryPointCode()
    {
        return $this->DeliveryPointCode;
    }
    /**
     * Set DeliveryPointCode value
     * @param string $deliveryPointCode
     * @return \StructType\DespatchBaseRequest
     */
    public function setDeliveryPointCode($deliveryPointCode = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPointCode) && !is_string($deliveryPointCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPointCode, true), gettype($deliveryPointCode)), __LINE__);
        }
        $this->DeliveryPointCode = $deliveryPointCode;
        return $this;
    }
    /**
     * Get DeliveryToEmail value
     * @return string|null
     */
    public function getDeliveryToEmail()
    {
        return $this->DeliveryToEmail;
    }
    /**
     * Set DeliveryToEmail value
     * @param string $deliveryToEmail
     * @return \StructType\DespatchBaseRequest
     */
    public function setDeliveryToEmail($deliveryToEmail = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryToEmail) && !is_string($deliveryToEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryToEmail, true), gettype($deliveryToEmail)), __LINE__);
        }
        $this->DeliveryToEmail = $deliveryToEmail;
        return $this;
    }
    /**
     * Get DeliveryToMobilePhone value
     * @return string|null
     */
    public function getDeliveryToMobilePhone()
    {
        return $this->DeliveryToMobilePhone;
    }
    /**
     * Set DeliveryToMobilePhone value
     * @param string $deliveryToMobilePhone
     * @return \StructType\DespatchBaseRequest
     */
    public function setDeliveryToMobilePhone($deliveryToMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryToMobilePhone) && !is_string($deliveryToMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryToMobilePhone, true), gettype($deliveryToMobilePhone)), __LINE__);
        }
        $this->DeliveryToMobilePhone = $deliveryToMobilePhone;
        return $this;
    }
    /**
     * Get DeliveryToName value
     * @return string|null
     */
    public function getDeliveryToName()
    {
        return $this->DeliveryToName;
    }
    /**
     * Set DeliveryToName value
     * @param string $deliveryToName
     * @return \StructType\DespatchBaseRequest
     */
    public function setDeliveryToName($deliveryToName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryToName) && !is_string($deliveryToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryToName, true), gettype($deliveryToName)), __LINE__);
        }
        $this->DeliveryToName = $deliveryToName;
        return $this;
    }
    /**
     * Get DeliveryToPhone value
     * @return string|null
     */
    public function getDeliveryToPhone()
    {
        return $this->DeliveryToPhone;
    }
    /**
     * Set DeliveryToPhone value
     * @param string $deliveryToPhone
     * @return \StructType\DespatchBaseRequest
     */
    public function setDeliveryToPhone($deliveryToPhone = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryToPhone) && !is_string($deliveryToPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryToPhone, true), gettype($deliveryToPhone)), __LINE__);
        }
        $this->DeliveryToPhone = $deliveryToPhone;
        return $this;
    }
    /**
     * Get DespatchDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDespatchDate()
    {
        return isset($this->DespatchDate) ? $this->DespatchDate : null;
    }
    /**
     * Set DespatchDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $despatchDate
     * @return \StructType\DespatchBaseRequest
     */
    public function setDespatchDate($despatchDate = null)
    {
        // validation for constraint: string
        if (!is_null($despatchDate) && !is_string($despatchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($despatchDate, true), gettype($despatchDate)), __LINE__);
        }
        if (is_null($despatchDate) || (is_array($despatchDate) && empty($despatchDate))) {
            unset($this->DespatchDate);
        } else {
            $this->DespatchDate = $despatchDate;
        }
        return $this;
    }
    /**
     * Get EORI value
     * @return string|null
     */
    public function getEORI()
    {
        return $this->EORI;
    }
    /**
     * Set EORI value
     * @param string $eORI
     * @return \StructType\DespatchBaseRequest
     */
    public function setEORI($eORI = null)
    {
        // validation for constraint: string
        if (!is_null($eORI) && !is_string($eORI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eORI, true), gettype($eORI)), __LINE__);
        }
        $this->EORI = $eORI;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\DespatchBaseRequest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get HouseholdSignature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHouseholdSignature()
    {
        return isset($this->HouseholdSignature) ? $this->HouseholdSignature : null;
    }
    /**
     * Set HouseholdSignature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $householdSignature
     * @return \StructType\DespatchBaseRequest
     */
    public function setHouseholdSignature($householdSignature = null)
    {
        // validation for constraint: boolean
        if (!is_null($householdSignature) && !is_bool($householdSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($householdSignature, true), gettype($householdSignature)), __LINE__);
        }
        if (is_null($householdSignature) || (is_array($householdSignature) && empty($householdSignature))) {
            unset($this->HouseholdSignature);
        } else {
            $this->HouseholdSignature = $householdSignature;
        }
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\DespatchBaseRequest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\DespatchBaseRequest
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get RetailValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRetailValue()
    {
        return isset($this->RetailValue) ? $this->RetailValue : null;
    }
    /**
     * Set RetailValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $retailValue
     * @return \StructType\DespatchBaseRequest
     */
    public function setRetailValue($retailValue = null)
    {
        // validation for constraint: float
        if (!is_null($retailValue) && !(is_float($retailValue) || is_numeric($retailValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($retailValue, true), gettype($retailValue)), __LINE__);
        }
        if (is_null($retailValue) || (is_array($retailValue) && empty($retailValue))) {
            unset($this->RetailValue);
        } else {
            $this->RetailValue = $retailValue;
        }
        return $this;
    }
    /**
     * Get ReturnAddress value
     * @return \StructType\AddressRequest|null
     */
    public function getReturnAddress()
    {
        return $this->ReturnAddress;
    }
    /**
     * Set ReturnAddress value
     * @param \StructType\AddressRequest $returnAddress
     * @return \StructType\DespatchBaseRequest
     */
    public function setReturnAddress(\StructType\AddressRequest $returnAddress = null)
    {
        $this->ReturnAddress = $returnAddress;
        return $this;
    }
    /**
     * Get Site value
     * @return string|null
     */
    public function getSite()
    {
        return $this->Site;
    }
    /**
     * Set Site value
     * @param string $site
     * @return \StructType\DespatchBaseRequest
     */
    public function setSite($site = null)
    {
        // validation for constraint: string
        if (!is_null($site) && !is_string($site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($site, true), gettype($site)), __LINE__);
        }
        $this->Site = $site;
        return $this;
    }
    /**
     * Get SpecialInstruction1 value
     * @return string|null
     */
    public function getSpecialInstruction1()
    {
        return $this->SpecialInstruction1;
    }
    /**
     * Set SpecialInstruction1 value
     * @param string $specialInstruction1
     * @return \StructType\DespatchBaseRequest
     */
    public function setSpecialInstruction1($specialInstruction1 = null)
    {
        // validation for constraint: string
        if (!is_null($specialInstruction1) && !is_string($specialInstruction1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInstruction1, true), gettype($specialInstruction1)), __LINE__);
        }
        $this->SpecialInstruction1 = $specialInstruction1;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\DespatchBaseRequest
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get VerboseMode value
     * @return string|null
     */
    public function getVerboseMode()
    {
        return $this->VerboseMode;
    }
    /**
     * Set VerboseMode value
     * @param string $verboseMode
     * @return \StructType\DespatchBaseRequest
     */
    public function setVerboseMode($verboseMode = null)
    {
        // validation for constraint: string
        if (!is_null($verboseMode) && !is_string($verboseMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verboseMode, true), gettype($verboseMode)), __LINE__);
        }
        $this->VerboseMode = $verboseMode;
        return $this;
    }
}
