<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateTrackingRequest StructType
 * @subpackage Structs
 */
class CreateTrackingRequest extends AbstractStructBase
{
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Timestamp;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventCode;
    /**
     * The LorryReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LorryReference;
    /**
     * The LorryRegistration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LorryRegistration;
    /**
     * The LorrySealNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LorrySealNumber;
    /**
     * The LorryTrailer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LorryTrailer;
    /**
     * The PalletID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PalletID;
    /**
     * The PalletSortCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PalletSortCode;
    /**
     * The PalletSortName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PalletSortName;
    /**
     * The Upi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Upi;
    /**
     * Constructor method for CreateTrackingRequest
     * @uses CreateTrackingRequest::setTimestamp()
     * @uses CreateTrackingRequest::setExtensionData()
     * @uses CreateTrackingRequest::setCarrierCode()
     * @uses CreateTrackingRequest::setEventCode()
     * @uses CreateTrackingRequest::setLorryReference()
     * @uses CreateTrackingRequest::setLorryRegistration()
     * @uses CreateTrackingRequest::setLorrySealNumber()
     * @uses CreateTrackingRequest::setLorryTrailer()
     * @uses CreateTrackingRequest::setPalletID()
     * @uses CreateTrackingRequest::setPalletSortCode()
     * @uses CreateTrackingRequest::setPalletSortName()
     * @uses CreateTrackingRequest::setUpi()
     * @param string $timestamp
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $eventCode
     * @param string $lorryReference
     * @param string $lorryRegistration
     * @param string $lorrySealNumber
     * @param string $lorryTrailer
     * @param string $palletID
     * @param string $palletSortCode
     * @param string $palletSortName
     * @param string $upi
     */
    public function __construct($timestamp = null, \StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $eventCode = null, $lorryReference = null, $lorryRegistration = null, $lorrySealNumber = null, $lorryTrailer = null, $palletID = null, $palletSortCode = null, $palletSortName = null, $upi = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setEventCode($eventCode)
            ->setLorryReference($lorryReference)
            ->setLorryRegistration($lorryRegistration)
            ->setLorrySealNumber($lorrySealNumber)
            ->setLorryTrailer($lorryTrailer)
            ->setPalletID($palletID)
            ->setPalletSortCode($palletSortCode)
            ->setPalletSortName($palletSortName)
            ->setUpi($upi);
    }
    /**
     * Get Timestamp value
     * @return string
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \StructType\CreateTrackingRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\CreateTrackingRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\CreateTrackingRequest
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\CreateTrackingRequest
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get LorryReference value
     * @return string|null
     */
    public function getLorryReference()
    {
        return $this->LorryReference;
    }
    /**
     * Set LorryReference value
     * @param string $lorryReference
     * @return \StructType\CreateTrackingRequest
     */
    public function setLorryReference($lorryReference = null)
    {
        // validation for constraint: string
        if (!is_null($lorryReference) && !is_string($lorryReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lorryReference, true), gettype($lorryReference)), __LINE__);
        }
        $this->LorryReference = $lorryReference;
        return $this;
    }
    /**
     * Get LorryRegistration value
     * @return string|null
     */
    public function getLorryRegistration()
    {
        return $this->LorryRegistration;
    }
    /**
     * Set LorryRegistration value
     * @param string $lorryRegistration
     * @return \StructType\CreateTrackingRequest
     */
    public function setLorryRegistration($lorryRegistration = null)
    {
        // validation for constraint: string
        if (!is_null($lorryRegistration) && !is_string($lorryRegistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lorryRegistration, true), gettype($lorryRegistration)), __LINE__);
        }
        $this->LorryRegistration = $lorryRegistration;
        return $this;
    }
    /**
     * Get LorrySealNumber value
     * @return string|null
     */
    public function getLorrySealNumber()
    {
        return $this->LorrySealNumber;
    }
    /**
     * Set LorrySealNumber value
     * @param string $lorrySealNumber
     * @return \StructType\CreateTrackingRequest
     */
    public function setLorrySealNumber($lorrySealNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lorrySealNumber) && !is_string($lorrySealNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lorrySealNumber, true), gettype($lorrySealNumber)), __LINE__);
        }
        $this->LorrySealNumber = $lorrySealNumber;
        return $this;
    }
    /**
     * Get LorryTrailer value
     * @return string|null
     */
    public function getLorryTrailer()
    {
        return $this->LorryTrailer;
    }
    /**
     * Set LorryTrailer value
     * @param string $lorryTrailer
     * @return \StructType\CreateTrackingRequest
     */
    public function setLorryTrailer($lorryTrailer = null)
    {
        // validation for constraint: string
        if (!is_null($lorryTrailer) && !is_string($lorryTrailer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lorryTrailer, true), gettype($lorryTrailer)), __LINE__);
        }
        $this->LorryTrailer = $lorryTrailer;
        return $this;
    }
    /**
     * Get PalletID value
     * @return string|null
     */
    public function getPalletID()
    {
        return $this->PalletID;
    }
    /**
     * Set PalletID value
     * @param string $palletID
     * @return \StructType\CreateTrackingRequest
     */
    public function setPalletID($palletID = null)
    {
        // validation for constraint: string
        if (!is_null($palletID) && !is_string($palletID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletID, true), gettype($palletID)), __LINE__);
        }
        $this->PalletID = $palletID;
        return $this;
    }
    /**
     * Get PalletSortCode value
     * @return string|null
     */
    public function getPalletSortCode()
    {
        return $this->PalletSortCode;
    }
    /**
     * Set PalletSortCode value
     * @param string $palletSortCode
     * @return \StructType\CreateTrackingRequest
     */
    public function setPalletSortCode($palletSortCode = null)
    {
        // validation for constraint: string
        if (!is_null($palletSortCode) && !is_string($palletSortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletSortCode, true), gettype($palletSortCode)), __LINE__);
        }
        $this->PalletSortCode = $palletSortCode;
        return $this;
    }
    /**
     * Get PalletSortName value
     * @return string|null
     */
    public function getPalletSortName()
    {
        return $this->PalletSortName;
    }
    /**
     * Set PalletSortName value
     * @param string $palletSortName
     * @return \StructType\CreateTrackingRequest
     */
    public function setPalletSortName($palletSortName = null)
    {
        // validation for constraint: string
        if (!is_null($palletSortName) && !is_string($palletSortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($palletSortName, true), gettype($palletSortName)), __LINE__);
        }
        $this->PalletSortName = $palletSortName;
        return $this;
    }
    /**
     * Get Upi value
     * @return string|null
     */
    public function getUpi()
    {
        return $this->Upi;
    }
    /**
     * Set Upi value
     * @param string $upi
     * @return \StructType\CreateTrackingRequest
     */
    public function setUpi($upi = null)
    {
        // validation for constraint: string
        if (!is_null($upi) && !is_string($upi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upi, true), gettype($upi)), __LINE__);
        }
        $this->Upi = $upi;
        return $this;
    }
}
