<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateNormalisedEventRequest StructType
 * @subpackage Structs
 */
class CreateNormalisedEventRequest extends AbstractStructBase
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientCode;
    /**
     * The ConsignmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsignmentNo;
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventCode;
    /**
     * The Upi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Upi;
    /**
     * Constructor method for CreateNormalisedEventRequest
     * @uses CreateNormalisedEventRequest::setEventDate()
     * @uses CreateNormalisedEventRequest::setExtensionData()
     * @uses CreateNormalisedEventRequest::setClientCode()
     * @uses CreateNormalisedEventRequest::setConsignmentNo()
     * @uses CreateNormalisedEventRequest::setEventCode()
     * @uses CreateNormalisedEventRequest::setUpi()
     * @param string $eventDate
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $clientCode
     * @param string $consignmentNo
     * @param string $eventCode
     * @param string $upi
     */
    public function __construct($eventDate = null, \StructType\ExtensionDataObject $extensionData = null, $clientCode = null, $consignmentNo = null, $eventCode = null, $upi = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setExtensionData($extensionData)
            ->setClientCode($clientCode)
            ->setConsignmentNo($consignmentNo)
            ->setEventCode($eventCode)
            ->setUpi($upi);
    }
    /**
     * Get EventDate value
     * @return string
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \StructType\CreateNormalisedEventRequest
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\CreateNormalisedEventRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get ClientCode value
     * @return string|null
     */
    public function getClientCode()
    {
        return $this->ClientCode;
    }
    /**
     * Set ClientCode value
     * @param string $clientCode
     * @return \StructType\CreateNormalisedEventRequest
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        $this->ClientCode = $clientCode;
        return $this;
    }
    /**
     * Get ConsignmentNo value
     * @return string|null
     */
    public function getConsignmentNo()
    {
        return $this->ConsignmentNo;
    }
    /**
     * Set ConsignmentNo value
     * @param string $consignmentNo
     * @return \StructType\CreateNormalisedEventRequest
     */
    public function setConsignmentNo($consignmentNo = null)
    {
        // validation for constraint: string
        if (!is_null($consignmentNo) && !is_string($consignmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consignmentNo, true), gettype($consignmentNo)), __LINE__);
        }
        $this->ConsignmentNo = $consignmentNo;
        return $this;
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \StructType\CreateNormalisedEventRequest
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get Upi value
     * @return string|null
     */
    public function getUpi()
    {
        return $this->Upi;
    }
    /**
     * Set Upi value
     * @param string $upi
     * @return \StructType\CreateNormalisedEventRequest
     */
    public function setUpi($upi = null)
    {
        // validation for constraint: string
        if (!is_null($upi) && !is_string($upi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upi, true), gettype($upi)), __LINE__);
        }
        $this->Upi = $upi;
        return $this;
    }
}
