<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateBookingRequest StructType
 * @subpackage Structs
 */
class CreateBookingRequest extends AbstractStructBase
{
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The SiteCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SiteCode;
    /**
     * Constructor method for CreateBookingRequest
     * @uses CreateBookingRequest::setExtensionData()
     * @uses CreateBookingRequest::setCarrierCode()
     * @uses CreateBookingRequest::setSiteCode()
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $siteCode
     */
    public function __construct(\StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $siteCode = null)
    {
        $this
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setSiteCode($siteCode);
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\CreateBookingRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\CreateBookingRequest
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get SiteCode value
     * @return string|null
     */
    public function getSiteCode()
    {
        return $this->SiteCode;
    }
    /**
     * Set SiteCode value
     * @param string $siteCode
     * @return \StructType\CreateBookingRequest
     */
    public function setSiteCode($siteCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCode) && !is_string($siteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCode, true), gettype($siteCode)), __LINE__);
        }
        $this->SiteCode = $siteCode;
        return $this;
    }
}
