<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientDespatchMethodInformation StructType
 * @subpackage Structs
 */
class ClientDespatchMethodInformation extends AbstractStructBase
{
    /**
     * The BasicCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BasicCost;
    /**
     * The IncrementalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IncrementalCost;
    /**
     * The SurchargeTotalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SurchargeTotalCost;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCost;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CarrierCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierCode;
    /**
     * The CarrierName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarrierName;
    /**
     * The ClientDespatchMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientDespatchMethod;
    /**
     * The ClientDespatchMethodDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientDespatchMethodDescription;
    /**
     * The RejectionReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RejectionReason;
    /**
     * The Surcharges
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSurchargeMember
     */
    public $Surcharges;
    /**
     * Constructor method for ClientDespatchMethodInformation
     * @uses ClientDespatchMethodInformation::setBasicCost()
     * @uses ClientDespatchMethodInformation::setIncrementalCost()
     * @uses ClientDespatchMethodInformation::setSurchargeTotalCost()
     * @uses ClientDespatchMethodInformation::setTotalCost()
     * @uses ClientDespatchMethodInformation::setExtensionData()
     * @uses ClientDespatchMethodInformation::setCarrierCode()
     * @uses ClientDespatchMethodInformation::setCarrierName()
     * @uses ClientDespatchMethodInformation::setClientDespatchMethod()
     * @uses ClientDespatchMethodInformation::setClientDespatchMethodDescription()
     * @uses ClientDespatchMethodInformation::setRejectionReason()
     * @uses ClientDespatchMethodInformation::setSurcharges()
     * @param float $basicCost
     * @param float $incrementalCost
     * @param float $surchargeTotalCost
     * @param float $totalCost
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $carrierCode
     * @param string $carrierName
     * @param string $clientDespatchMethod
     * @param string $clientDespatchMethodDescription
     * @param string $rejectionReason
     * @param \ArrayType\ArrayOfSurchargeMember $surcharges
     */
    public function __construct($basicCost = null, $incrementalCost = null, $surchargeTotalCost = null, $totalCost = null, \StructType\ExtensionDataObject $extensionData = null, $carrierCode = null, $carrierName = null, $clientDespatchMethod = null, $clientDespatchMethodDescription = null, $rejectionReason = null, \ArrayType\ArrayOfSurchargeMember $surcharges = null)
    {
        $this
            ->setBasicCost($basicCost)
            ->setIncrementalCost($incrementalCost)
            ->setSurchargeTotalCost($surchargeTotalCost)
            ->setTotalCost($totalCost)
            ->setExtensionData($extensionData)
            ->setCarrierCode($carrierCode)
            ->setCarrierName($carrierName)
            ->setClientDespatchMethod($clientDespatchMethod)
            ->setClientDespatchMethodDescription($clientDespatchMethodDescription)
            ->setRejectionReason($rejectionReason)
            ->setSurcharges($surcharges);
    }
    /**
     * Get BasicCost value
     * @return float
     */
    public function getBasicCost()
    {
        return $this->BasicCost;
    }
    /**
     * Set BasicCost value
     * @param float $basicCost
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setBasicCost($basicCost = null)
    {
        // validation for constraint: float
        if (!is_null($basicCost) && !(is_float($basicCost) || is_numeric($basicCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basicCost, true), gettype($basicCost)), __LINE__);
        }
        $this->BasicCost = $basicCost;
        return $this;
    }
    /**
     * Get IncrementalCost value
     * @return float
     */
    public function getIncrementalCost()
    {
        return $this->IncrementalCost;
    }
    /**
     * Set IncrementalCost value
     * @param float $incrementalCost
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setIncrementalCost($incrementalCost = null)
    {
        // validation for constraint: float
        if (!is_null($incrementalCost) && !(is_float($incrementalCost) || is_numeric($incrementalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($incrementalCost, true), gettype($incrementalCost)), __LINE__);
        }
        $this->IncrementalCost = $incrementalCost;
        return $this;
    }
    /**
     * Get SurchargeTotalCost value
     * @return float
     */
    public function getSurchargeTotalCost()
    {
        return $this->SurchargeTotalCost;
    }
    /**
     * Set SurchargeTotalCost value
     * @param float $surchargeTotalCost
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setSurchargeTotalCost($surchargeTotalCost = null)
    {
        // validation for constraint: float
        if (!is_null($surchargeTotalCost) && !(is_float($surchargeTotalCost) || is_numeric($surchargeTotalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($surchargeTotalCost, true), gettype($surchargeTotalCost)), __LINE__);
        }
        $this->SurchargeTotalCost = $surchargeTotalCost;
        return $this;
    }
    /**
     * Get TotalCost value
     * @return float
     */
    public function getTotalCost()
    {
        return $this->TotalCost;
    }
    /**
     * Set TotalCost value
     * @param float $totalCost
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        $this->TotalCost = $totalCost;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CarrierCode value
     * @return string|null
     */
    public function getCarrierCode()
    {
        return $this->CarrierCode;
    }
    /**
     * Set CarrierCode value
     * @param string $carrierCode
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setCarrierCode($carrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($carrierCode) && !is_string($carrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierCode, true), gettype($carrierCode)), __LINE__);
        }
        $this->CarrierCode = $carrierCode;
        return $this;
    }
    /**
     * Get CarrierName value
     * @return string|null
     */
    public function getCarrierName()
    {
        return $this->CarrierName;
    }
    /**
     * Set CarrierName value
     * @param string $carrierName
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrierName, true), gettype($carrierName)), __LINE__);
        }
        $this->CarrierName = $carrierName;
        return $this;
    }
    /**
     * Get ClientDespatchMethod value
     * @return string|null
     */
    public function getClientDespatchMethod()
    {
        return $this->ClientDespatchMethod;
    }
    /**
     * Set ClientDespatchMethod value
     * @param string $clientDespatchMethod
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setClientDespatchMethod($clientDespatchMethod = null)
    {
        // validation for constraint: string
        if (!is_null($clientDespatchMethod) && !is_string($clientDespatchMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDespatchMethod, true), gettype($clientDespatchMethod)), __LINE__);
        }
        $this->ClientDespatchMethod = $clientDespatchMethod;
        return $this;
    }
    /**
     * Get ClientDespatchMethodDescription value
     * @return string|null
     */
    public function getClientDespatchMethodDescription()
    {
        return $this->ClientDespatchMethodDescription;
    }
    /**
     * Set ClientDespatchMethodDescription value
     * @param string $clientDespatchMethodDescription
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setClientDespatchMethodDescription($clientDespatchMethodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($clientDespatchMethodDescription) && !is_string($clientDespatchMethodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDespatchMethodDescription, true), gettype($clientDespatchMethodDescription)), __LINE__);
        }
        $this->ClientDespatchMethodDescription = $clientDespatchMethodDescription;
        return $this;
    }
    /**
     * Get RejectionReason value
     * @return string|null
     */
    public function getRejectionReason()
    {
        return $this->RejectionReason;
    }
    /**
     * Set RejectionReason value
     * @param string $rejectionReason
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setRejectionReason($rejectionReason = null)
    {
        // validation for constraint: string
        if (!is_null($rejectionReason) && !is_string($rejectionReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rejectionReason, true), gettype($rejectionReason)), __LINE__);
        }
        $this->RejectionReason = $rejectionReason;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \ArrayType\ArrayOfSurchargeMember|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @param \ArrayType\ArrayOfSurchargeMember $surcharges
     * @return \StructType\ClientDespatchMethodInformation
     */
    public function setSurcharges(\ArrayType\ArrayOfSurchargeMember $surcharges = null)
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
}
