<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearCacheRequest StructType
 * @subpackage Structs
 */
class ClearCacheRequest extends AbstractStructBase
{
    /**
     * The CacheLevel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CacheLevel;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The RequesterUsername
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequesterUsername;
    /**
     * Constructor method for ClearCacheRequest
     * @uses ClearCacheRequest::setCacheLevel()
     * @uses ClearCacheRequest::setExtensionData()
     * @uses ClearCacheRequest::setRequesterUsername()
     * @param int $cacheLevel
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $requesterUsername
     */
    public function __construct($cacheLevel = null, \StructType\ExtensionDataObject $extensionData = null, $requesterUsername = null)
    {
        $this
            ->setCacheLevel($cacheLevel)
            ->setExtensionData($extensionData)
            ->setRequesterUsername($requesterUsername);
    }
    /**
     * Get CacheLevel value
     * @return int
     */
    public function getCacheLevel()
    {
        return $this->CacheLevel;
    }
    /**
     * Set CacheLevel value
     * @param int $cacheLevel
     * @return \StructType\ClearCacheRequest
     */
    public function setCacheLevel($cacheLevel = null)
    {
        // validation for constraint: int
        if (!is_null($cacheLevel) && !(is_int($cacheLevel) || ctype_digit($cacheLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cacheLevel, true), gettype($cacheLevel)), __LINE__);
        }
        $this->CacheLevel = $cacheLevel;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\ClearCacheRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get RequesterUsername value
     * @return string|null
     */
    public function getRequesterUsername()
    {
        return $this->RequesterUsername;
    }
    /**
     * Set RequesterUsername value
     * @param string $requesterUsername
     * @return \StructType\ClearCacheRequest
     */
    public function setRequesterUsername($requesterUsername = null)
    {
        // validation for constraint: string
        if (!is_null($requesterUsername) && !is_string($requesterUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requesterUsername, true), gettype($requesterUsername)), __LINE__);
        }
        $this->RequesterUsername = $requesterUsername;
        return $this;
    }
}
