<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressRequest StructType
 * @subpackage Structs
 */
class AddressRequest extends AbstractStructBase
{
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine3;
    /**
     * The AddressLine4
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AddressLine4;
    /**
     * The ExtensionData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ExtensionDataObject
     */
    public $ExtensionData;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The LocationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationCode;
    /**
     * The ToEmail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToEmail;
    /**
     * The ToMobilePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToMobilePhone;
    /**
     * The ToPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToPhone;
    /**
     * Constructor method for AddressRequest
     * @uses AddressRequest::setAddressLine1()
     * @uses AddressRequest::setAddressLine2()
     * @uses AddressRequest::setAddressLine3()
     * @uses AddressRequest::setAddressLine4()
     * @uses AddressRequest::setExtensionData()
     * @uses AddressRequest::setCountryCode()
     * @uses AddressRequest::setFirstName()
     * @uses AddressRequest::setLastName()
     * @uses AddressRequest::setLocationCode()
     * @uses AddressRequest::setToEmail()
     * @uses AddressRequest::setToMobilePhone()
     * @uses AddressRequest::setToPhone()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $addressLine4
     * @param \StructType\ExtensionDataObject $extensionData
     * @param string $countryCode
     * @param string $firstName
     * @param string $lastName
     * @param string $locationCode
     * @param string $toEmail
     * @param string $toMobilePhone
     * @param string $toPhone
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $addressLine4 = null, \StructType\ExtensionDataObject $extensionData = null, $countryCode = null, $firstName = null, $lastName = null, $locationCode = null, $toEmail = null, $toMobilePhone = null, $toPhone = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setAddressLine4($addressLine4)
            ->setExtensionData($extensionData)
            ->setCountryCode($countryCode)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setLocationCode($locationCode)
            ->setToEmail($toEmail)
            ->setToMobilePhone($toMobilePhone)
            ->setToPhone($toPhone);
    }
    /**
     * Get AddressLine1 value
     * @return string
     */
    public function getAddressLine1()
    {
        return $this->AddressLine1;
    }
    /**
     * Set AddressLine1 value
     * @param string $addressLine1
     * @return \StructType\AddressRequest
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        $this->AddressLine1 = $addressLine1;
        return $this;
    }
    /**
     * Get AddressLine2 value
     * @return string
     */
    public function getAddressLine2()
    {
        return $this->AddressLine2;
    }
    /**
     * Set AddressLine2 value
     * @param string $addressLine2
     * @return \StructType\AddressRequest
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        $this->AddressLine2 = $addressLine2;
        return $this;
    }
    /**
     * Get AddressLine3 value
     * @return string
     */
    public function getAddressLine3()
    {
        return $this->AddressLine3;
    }
    /**
     * Set AddressLine3 value
     * @param string $addressLine3
     * @return \StructType\AddressRequest
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        $this->AddressLine3 = $addressLine3;
        return $this;
    }
    /**
     * Get AddressLine4 value
     * @return string
     */
    public function getAddressLine4()
    {
        return $this->AddressLine4;
    }
    /**
     * Set AddressLine4 value
     * @param string $addressLine4
     * @return \StructType\AddressRequest
     */
    public function setAddressLine4($addressLine4 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine4) && !is_string($addressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine4, true), gettype($addressLine4)), __LINE__);
        }
        $this->AddressLine4 = $addressLine4;
        return $this;
    }
    /**
     * Get ExtensionData value
     * @return \StructType\ExtensionDataObject|null
     */
    public function getExtensionData()
    {
        return $this->ExtensionData;
    }
    /**
     * Set ExtensionData value
     * @param \StructType\ExtensionDataObject $extensionData
     * @return \StructType\AddressRequest
     */
    public function setExtensionData(\StructType\ExtensionDataObject $extensionData = null)
    {
        $this->ExtensionData = $extensionData;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\AddressRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\AddressRequest
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\AddressRequest
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \StructType\AddressRequest
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationCode, true), gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get ToEmail value
     * @return string|null
     */
    public function getToEmail()
    {
        return $this->ToEmail;
    }
    /**
     * Set ToEmail value
     * @param string $toEmail
     * @return \StructType\AddressRequest
     */
    public function setToEmail($toEmail = null)
    {
        // validation for constraint: string
        if (!is_null($toEmail) && !is_string($toEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEmail, true), gettype($toEmail)), __LINE__);
        }
        $this->ToEmail = $toEmail;
        return $this;
    }
    /**
     * Get ToMobilePhone value
     * @return string|null
     */
    public function getToMobilePhone()
    {
        return $this->ToMobilePhone;
    }
    /**
     * Set ToMobilePhone value
     * @param string $toMobilePhone
     * @return \StructType\AddressRequest
     */
    public function setToMobilePhone($toMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($toMobilePhone) && !is_string($toMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toMobilePhone, true), gettype($toMobilePhone)), __LINE__);
        }
        $this->ToMobilePhone = $toMobilePhone;
        return $this;
    }
    /**
     * Get ToPhone value
     * @return string|null
     */
    public function getToPhone()
    {
        return $this->ToPhone;
    }
    /**
     * Set ToPhone value
     * @param string $toPhone
     * @return \StructType\AddressRequest
     */
    public function setToPhone($toPhone = null)
    {
        // validation for constraint: string
        if (!is_null($toPhone) && !is_string($toPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toPhone, true), gettype($toPhone)), __LINE__);
        }
        $this->ToPhone = $toPhone;
        return $this;
    }
}
