<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Print ServiceType
 * @subpackage Services
 */
class _Print extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PrintLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrintLabel $parameters
     * @return \StructType\PrintLabelResponse|bool
     */
    public function PrintLabel(\StructType\PrintLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrintLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrintLabelForDespatchManager
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrintLabelForDespatchManager $parameters
     * @return \StructType\PrintLabelForDespatchManagerResponse|bool
     */
    public function PrintLabelForDespatchManager(\StructType\PrintLabelForDespatchManager $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrintLabelForDespatchManager($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrintManifest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrintManifest $parameters
     * @return \StructType\PrintManifestResponse|bool
     */
    public function PrintManifest(\StructType\PrintManifest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrintManifest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrintServerAuditLog
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrintServerAuditLog $parameters
     * @return \StructType\PrintServerAuditLogResponse|bool
     */
    public function PrintServerAuditLog(\StructType\PrintServerAuditLog $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrintServerAuditLog($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PrintLabelForDespatchManagerResponse|\StructType\PrintLabelResponse|\StructType\PrintManifestResponse|\StructType\PrintServerAuditLogResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
