<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Store ServiceType
 * @subpackage Services
 */
class Store extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StoreCustomerOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StoreCustomerOrder $parameters
     * @return \StructType\StoreCustomerOrderResponse|bool
     */
    public function StoreCustomerOrder(\StructType\StoreCustomerOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StoreCustomerOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StoreCustomerOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
