<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reprint ServiceType
 * @subpackage Services
 */
class Reprint extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReprintLabel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReprintLabel $parameters
     * @return \StructType\ReprintLabelResponse|bool
     */
    public function ReprintLabel(\StructType\ReprintLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReprintLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReprintLabelResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
