<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Export ServiceType
 * @subpackage Services
 */
class Export extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExportBooking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportBooking $parameters
     * @return \StructType\ExportBookingResponse|bool
     */
    public function ExportBooking(\StructType\ExportBooking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExportBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExportManifest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportManifest $parameters
     * @return \StructType\ExportManifestResponse|bool
     */
    public function ExportManifest(\StructType\ExportManifest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExportManifest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExportTracking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportTracking $parameters
     * @return \StructType\ExportTrackingResponse|bool
     */
    public function ExportTracking(\StructType\ExportTracking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ExportTracking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExportBookingResponse|\StructType\ExportManifestResponse|\StructType\ExportTrackingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
