<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Confirm ServiceType
 * @subpackage Services
 */
class Confirm extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConfirmDespatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConfirmDespatch $parameters
     * @return \StructType\ConfirmDespatchResponse|bool
     */
    public function ConfirmDespatch(\StructType\ConfirmDespatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConfirmDespatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConfirmDespatchResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
