<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfClickCollectStore ArrayType
 * @subpackage Arrays
 */
class ArrayOfClickCollectStore extends AbstractStructArrayBase
{
    /**
     * The ClickCollectStore
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ClickCollectStore[]
     */
    public $ClickCollectStore;
    /**
     * Constructor method for ArrayOfClickCollectStore
     * @uses ArrayOfClickCollectStore::setClickCollectStore()
     * @param \StructType\ClickCollectStore[] $clickCollectStore
     */
    public function __construct(array $clickCollectStore = array())
    {
        $this
            ->setClickCollectStore($clickCollectStore);
    }
    /**
     * Get ClickCollectStore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ClickCollectStore[]|null
     */
    public function getClickCollectStore()
    {
        return isset($this->ClickCollectStore) ? $this->ClickCollectStore : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClickCollectStore method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClickCollectStore method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClickCollectStoreForArrayConstraintsFromSetClickCollectStore(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfClickCollectStoreClickCollectStoreItem) {
            // validation for constraint: itemType
            if (!$arrayOfClickCollectStoreClickCollectStoreItem instanceof \StructType\ClickCollectStore) {
                $invalidValues[] = is_object($arrayOfClickCollectStoreClickCollectStoreItem) ? get_class($arrayOfClickCollectStoreClickCollectStoreItem) : sprintf('%s(%s)', gettype($arrayOfClickCollectStoreClickCollectStoreItem), var_export($arrayOfClickCollectStoreClickCollectStoreItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClickCollectStore property can only contain items of type \StructType\ClickCollectStore, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClickCollectStore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClickCollectStore[] $clickCollectStore
     * @return \ArrayType\ArrayOfClickCollectStore
     */
    public function setClickCollectStore(array $clickCollectStore = array())
    {
        // validation for constraint: array
        if ('' !== ($clickCollectStoreArrayErrorMessage = self::validateClickCollectStoreForArrayConstraintsFromSetClickCollectStore($clickCollectStore))) {
            throw new \InvalidArgumentException($clickCollectStoreArrayErrorMessage, __LINE__);
        }
        if (is_null($clickCollectStore) || (is_array($clickCollectStore) && empty($clickCollectStore))) {
            unset($this->ClickCollectStore);
        } else {
            $this->ClickCollectStore = $clickCollectStore;
        }
        return $this;
    }
    /**
     * Add item to ClickCollectStore value
     * @throws \InvalidArgumentException
     * @param \StructType\ClickCollectStore $item
     * @return \ArrayType\ArrayOfClickCollectStore
     */
    public function addToClickCollectStore(\StructType\ClickCollectStore $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClickCollectStore) {
            throw new \InvalidArgumentException(sprintf('The ClickCollectStore property can only contain items of type \StructType\ClickCollectStore, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClickCollectStore[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ClickCollectStore|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ClickCollectStore|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ClickCollectStore|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ClickCollectStore|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ClickCollectStore|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ClickCollectStore
     */
    public function getAttributeName()
    {
        return 'ClickCollectStore';
    }
}
