<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://cgmix.uscg.mil/xml/PSIXData.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://cgmix.uscg.mil/xml/PSIXData.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getVesselSummary operation/method
 */
if ($get->getVesselSummary(new \StructType\GetVesselSummary()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselDocuments operation/method
 */
if ($get->getVesselDocuments(new \StructType\GetVesselDocuments()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOperationControls operation/method
 */
if ($get->getOperationControls(new \StructType\GetOperationControls()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselParticulars operation/method
 */
if ($get->getVesselParticulars(new \StructType\GetVesselParticulars()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselDimensions operation/method
 */
if ($get->getVesselDimensions(new \StructType\GetVesselDimensions()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselTonnage operation/method
 */
if ($get->getVesselTonnage(new \StructType\GetVesselTonnage()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselCases operation/method
 */
if ($get->getVesselCases(new \StructType\GetVesselCases()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselDeficiencies operation/method
 */
if ($get->getVesselDeficiencies(new \StructType\GetVesselDeficiencies()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselSummaryXMLString operation/method
 */
if ($get->getVesselSummaryXMLString(new \StructType\GetVesselSummaryXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselDocumentsXMLString operation/method
 */
if ($get->getVesselDocumentsXMLString(new \StructType\GetVesselDocumentsXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOperationControlsXMLString operation/method
 */
if ($get->getOperationControlsXMLString(new \StructType\GetOperationControlsXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselParticularsXMLString operation/method
 */
if ($get->getVesselParticularsXMLString(new \StructType\GetVesselParticularsXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselDimensionsXMLString operation/method
 */
if ($get->getVesselDimensionsXMLString(new \StructType\GetVesselDimensionsXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselTonnageXMLString operation/method
 */
if ($get->getVesselTonnageXMLString(new \StructType\GetVesselTonnageXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselCasesXMLString operation/method
 */
if ($get->getVesselCasesXMLString(new \StructType\GetVesselCasesXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVesselDeficienciesXMLString operation/method
 */
if ($get->getVesselDeficienciesXMLString(new \StructType\GetVesselDeficienciesXMLString()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
