<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Select ServiceType
 * @subpackage Services
 */
class Select extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SelectKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectKategori $parameters
     * @return \StructType\SelectKategoriResponse|bool
     */
    public function SelectKategori(\StructType\SelectKategori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectMarka
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectMarka $parameters
     * @return \StructType\SelectMarkaResponse|bool
     */
    public function SelectMarka(\StructType\SelectMarka $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectMarka($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTedarikci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTedarikci $parameters
     * @return \StructType\SelectTedarikciResponse|bool
     */
    public function SelectTedarikci(\StructType\SelectTedarikci $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectTedarikci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectEtiket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectEtiket $parameters
     * @return \StructType\SelectEtiketResponse|bool
     */
    public function SelectEtiket(\StructType\SelectEtiket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectEtiket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectParaBirimi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectParaBirimi $parameters
     * @return \StructType\SelectParaBirimiResponse|bool
     */
    public function SelectParaBirimi(\StructType\SelectParaBirimi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectParaBirimi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTeknikDetayGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTeknikDetayGrup $parameters
     * @return \StructType\SelectTeknikDetayGrupResponse|bool
     */
    public function SelectTeknikDetayGrup(\StructType\SelectTeknikDetayGrup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectTeknikDetayGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTeknikDetayOzellik
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTeknikDetayOzellik $parameters
     * @return \StructType\SelectTeknikDetayOzellikResponse|bool
     */
    public function SelectTeknikDetayOzellik(\StructType\SelectTeknikDetayOzellik $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectTeknikDetayOzellik($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTeknikDetayDeger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTeknikDetayDeger $parameters
     * @return \StructType\SelectTeknikDetayDegerResponse|bool
     */
    public function SelectTeknikDetayDeger(\StructType\SelectTeknikDetayDeger $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectTeknikDetayDeger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectAsortiGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectAsortiGrup $parameters
     * @return \StructType\SelectAsortiGrupResponse|bool
     */
    public function SelectAsortiGrup(\StructType\SelectAsortiGrup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectAsortiGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectAsortiMiktar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectAsortiMiktar $parameters
     * @return \StructType\SelectAsortiMiktarResponse|bool
     */
    public function SelectAsortiMiktar(\StructType\SelectAsortiMiktar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectAsortiMiktar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectEkSecenekGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectEkSecenekGrup $parameters
     * @return \StructType\SelectEkSecenekGrupResponse|bool
     */
    public function SelectEkSecenekGrup(\StructType\SelectEkSecenekGrup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectEkSecenekGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectEkSecenekDeger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectEkSecenekDeger $parameters
     * @return \StructType\SelectEkSecenekDegerResponse|bool
     */
    public function SelectEkSecenekDeger(\StructType\SelectEkSecenekDeger $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectEkSecenekDeger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrun $parameters
     * @return \StructType\SelectUrunResponse|bool
     */
    public function SelectUrun(\StructType\SelectUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunCount $parameters
     * @return \StructType\SelectUrunCountResponse|bool
     */
    public function SelectUrunCount(\StructType\SelectUrunCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectVaryasyon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectVaryasyon $parameters
     * @return \StructType\SelectVaryasyonResponse|bool
     */
    public function SelectVaryasyon(\StructType\SelectVaryasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectVaryasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectVaryasyonCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectVaryasyonCount $parameters
     * @return \StructType\SelectVaryasyonCountResponse|bool
     */
    public function SelectVaryasyonCount(\StructType\SelectVaryasyonCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectVaryasyonCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectMagazaStok
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectMagazaStok $parameters
     * @return \StructType\SelectMagazaStokResponse|bool
     */
    public function SelectMagazaStok(\StructType\SelectMagazaStok $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectMagazaStok($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunOdemeSecenek
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunOdemeSecenek $parameters
     * @return \StructType\SelectUrunOdemeSecenekResponse|bool
     */
    public function SelectUrunOdemeSecenek(\StructType\SelectUrunOdemeSecenek $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunOdemeSecenek($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunYorum
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunYorum $parameters
     * @return \StructType\SelectUrunYorumResponse|bool
     */
    public function SelectUrunYorum(\StructType\SelectUrunYorum $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunYorum($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunKategori $parameters
     * @return \StructType\SelectUrunKategoriResponse|bool
     */
    public function SelectUrunKategori(\StructType\SelectUrunKategori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunEtiket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunEtiket $parameters
     * @return \StructType\SelectUrunEtiketResponse|bool
     */
    public function SelectUrunEtiket(\StructType\SelectUrunEtiket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunEtiket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectIlgiliUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectIlgiliUrun $parameters
     * @return \StructType\SelectIlgiliUrunResponse|bool
     */
    public function SelectIlgiliUrun(\StructType\SelectIlgiliUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectIlgiliUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunResim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunResim $parameters
     * @return \StructType\SelectUrunResimResponse|bool
     */
    public function SelectUrunResim(\StructType\SelectUrunResim $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunResim($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectKombinUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectKombinUrun $parameters
     * @return \StructType\SelectKombinUrunResponse_1|bool
     */
    public function SelectKombinUrun(\StructType\SelectKombinUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectKombinUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTamamlayiciUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTamamlayiciUrun $parameters
     * @return \StructType\SelectTamamlayiciUrunResponse|bool
     */
    public function SelectTamamlayiciUrun(\StructType\SelectTamamlayiciUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectTamamlayiciUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectTakimUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectTakimUrun $parameters
     * @return \StructType\SelectTakimUrunResponse|bool
     */
    public function SelectTakimUrun(\StructType\SelectTakimUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectTakimUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SelectUrunDetayTab
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SelectUrunDetayTab $parameters
     * @return \StructType\SelectUrunDetayTabResponse|bool
     */
    public function SelectUrunDetayTab(\StructType\SelectUrunDetayTab $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SelectUrunDetayTab($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SelectAsortiGrupResponse|\StructType\SelectAsortiMiktarResponse|\StructType\SelectEkSecenekDegerResponse|\StructType\SelectEkSecenekGrupResponse|\StructType\SelectEtiketResponse|\StructType\SelectIlgiliUrunResponse|\StructType\SelectKategoriResponse|\StructType\SelectKombinUrunResponse_1|\StructType\SelectMagazaStokResponse|\StructType\SelectMarkaResponse|\StructType\SelectParaBirimiResponse|\StructType\SelectTakimUrunResponse|\StructType\SelectTamamlayiciUrunResponse|\StructType\SelectTedarikciResponse|\StructType\SelectTeknikDetayDegerResponse|\StructType\SelectTeknikDetayGrupResponse|\StructType\SelectTeknikDetayOzellikResponse|\StructType\SelectUrunCountResponse|\StructType\SelectUrunDetayTabResponse|\StructType\SelectUrunEtiketResponse|\StructType\SelectUrunKategoriResponse|\StructType\SelectUrunOdemeSecenekResponse|\StructType\SelectUrunResimResponse|\StructType\SelectUrunResponse|\StructType\SelectUrunYorumResponse|\StructType\SelectVaryasyonCountResponse|\StructType\SelectVaryasyonResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
