<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveKategori $parameters
     * @return \StructType\SaveKategoriResponse|bool
     */
    public function SaveKategori(\StructType\SaveKategori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveKategoriParent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveKategoriParent $parameters
     * @return \StructType\SaveKategoriParentResponse|bool
     */
    public function SaveKategoriParent(\StructType\SaveKategoriParent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveKategoriParent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMarka
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMarka $parameters
     * @return \StructType\SaveMarkaResponse|bool
     */
    public function SaveMarka(\StructType\SaveMarka $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMarka($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTedarikci
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTedarikci $parameters
     * @return \StructType\SaveTedarikciResponse|bool
     */
    public function SaveTedarikci(\StructType\SaveTedarikci $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveTedarikci($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveEtiket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveEtiket $parameters
     * @return \StructType\SaveEtiketResponse|bool
     */
    public function SaveEtiket(\StructType\SaveEtiket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveEtiket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveParaBirimi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveParaBirimi $parameters
     * @return \StructType\SaveParaBirimiResponse|bool
     */
    public function SaveParaBirimi(\StructType\SaveParaBirimi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveParaBirimi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTeknikDetayGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTeknikDetayGrup $parameters
     * @return \StructType\SaveTeknikDetayGrupResponse|bool
     */
    public function SaveTeknikDetayGrup(\StructType\SaveTeknikDetayGrup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveTeknikDetayGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTeknikDetayOzellik
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTeknikDetayOzellik $parameters
     * @return \StructType\SaveTeknikDetayOzellikResponse|bool
     */
    public function SaveTeknikDetayOzellik(\StructType\SaveTeknikDetayOzellik $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveTeknikDetayOzellik($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTeknikDetayDeger
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTeknikDetayDeger $parameters
     * @return \StructType\SaveTeknikDetayDegerResponse|bool
     */
    public function SaveTeknikDetayDeger(\StructType\SaveTeknikDetayDeger $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveTeknikDetayDeger($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAsortiGrup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveAsortiGrup $parameters
     * @return \StructType\SaveAsortiGrupResponse|bool
     */
    public function SaveAsortiGrup(\StructType\SaveAsortiGrup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveAsortiGrup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveAsortiMiktar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveAsortiMiktar $parameters
     * @return \StructType\SaveAsortiMiktarResponse|bool
     */
    public function SaveAsortiMiktar(\StructType\SaveAsortiMiktar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveAsortiMiktar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUrun $parameters
     * @return \StructType\SaveUrunResponse|bool
     */
    public function SaveUrun(\StructType\SaveUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveVaryasyon
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveVaryasyon $parameters
     * @return \StructType\SaveVaryasyonResponse|bool
     */
    public function SaveVaryasyon(\StructType\SaveVaryasyon $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveVaryasyon($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveResim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveResim $parameters
     * @return \StructType\SaveResimResponse|bool
     */
    public function SaveResim(\StructType\SaveResim $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveResim($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveMagazaStok
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveMagazaStok $parameters
     * @return \StructType\SaveMagazaStokResponse|bool
     */
    public function SaveMagazaStok(\StructType\SaveMagazaStok $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveMagazaStok($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUrunKategori
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUrunKategori $parameters
     * @return \StructType\SaveUrunKategoriResponse|bool
     */
    public function SaveUrunKategori(\StructType\SaveUrunKategori $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveUrunKategori($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUrunEtiket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUrunEtiket $parameters
     * @return \StructType\SaveUrunEtiketResponse|bool
     */
    public function SaveUrunEtiket(\StructType\SaveUrunEtiket $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveUrunEtiket($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveIlgiliUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveIlgiliUrun $parameters
     * @return \StructType\SaveIlgiliUrunResponse|bool
     */
    public function SaveIlgiliUrun(\StructType\SaveIlgiliUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveIlgiliUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveKombinUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveKombinUrun $parameters
     * @return \StructType\SaveKombinUrunResponse|bool
     */
    public function SaveKombinUrun(\StructType\SaveKombinUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveKombinUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTamamlayiciUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTamamlayiciUrun $parameters
     * @return \StructType\SaveTamamlayiciUrunResponse|bool
     */
    public function SaveTamamlayiciUrun(\StructType\SaveTamamlayiciUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveTamamlayiciUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveTakimUrun
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveTakimUrun $parameters
     * @return \StructType\SaveTakimUrunResponse|bool
     */
    public function SaveTakimUrun(\StructType\SaveTakimUrun $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveTakimUrun($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaveUrunDetayTab
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SaveUrunDetayTab $parameters
     * @return \StructType\SaveUrunDetayTabResponse|bool
     */
    public function SaveUrunDetayTab(\StructType\SaveUrunDetayTab $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveUrunDetayTab($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SaveAsortiGrupResponse|\StructType\SaveAsortiMiktarResponse|\StructType\SaveEtiketResponse|\StructType\SaveIlgiliUrunResponse|\StructType\SaveKategoriParentResponse|\StructType\SaveKategoriResponse|\StructType\SaveKombinUrunResponse|\StructType\SaveMagazaStokResponse|\StructType\SaveMarkaResponse|\StructType\SaveParaBirimiResponse|\StructType\SaveResimResponse|\StructType\SaveTakimUrunResponse|\StructType\SaveTamamlayiciUrunResponse|\StructType\SaveTedarikciResponse|\StructType\SaveTeknikDetayDegerResponse|\StructType\SaveTeknikDetayGrupResponse|\StructType\SaveTeknikDetayOzellikResponse|\StructType\SaveUrunDetayTabResponse|\StructType\SaveUrunEtiketResponse|\StructType\SaveUrunKategoriResponse|\StructType\SaveUrunResponse|\StructType\SaveVaryasyonResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
