<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ssoptest.sfgcrm.com/SSOP.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ssoptest.sfgcrm.com/SSOP.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \optsoapsdk\ClassMap::get(),
);
/**
 * Samples for Validate ServiceType
 */
$validate = new \optsoapsdk\ServiceType\Validate($options);
/**
 * Sample call for ValidateLogin operation/method
 */
if ($validate->ValidateLogin(new \optsoapsdk\StructType\ValidateLogin()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \optsoapsdk\ServiceType\Create($options);
/**
 * Sample call for CreateAgent operation/method
 */
if ($create->CreateAgent(new \optsoapsdk\StructType\CreateAgent()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateReferral operation/method
 */
if ($create->CreateReferral(new \optsoapsdk\StructType\CreateReferral()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateApplicationTaken operation/method
 */
if ($create->CreateApplicationTaken(new \optsoapsdk\StructType\CreateApplicationTaken()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \optsoapsdk\ServiceType\Get($options);
/**
 * Sample call for GetAgentDetail operation/method
 */
if ($get->GetAgentDetail(new \optsoapsdk\StructType\GetAgentDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAgentLeads operation/method
 */
if ($get->GetAgentLeads(new \optsoapsdk\StructType\GetAgentLeads()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLeadDetail operation/method
 */
if ($get->GetLeadDetail(new \optsoapsdk\StructType\GetLeadDetail()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAgentLeadsSinceDate operation/method
 */
if ($get->GetAgentLeadsSinceDate(new \optsoapsdk\StructType\GetAgentLeadsSinceDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAgentApplicationsSinceDate operation/method
 */
if ($get->GetAgentApplicationsSinceDate(new \optsoapsdk\StructType\GetAgentApplicationsSinceDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetApplication operation/method
 */
if ($get->GetApplication(new \optsoapsdk\StructType\GetApplication()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetApplicationsCount operation/method
 */
if ($get->GetApplicationsCount(new \optsoapsdk\StructType\GetApplicationsCount()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPolicyType operation/method
 */
if ($get->GetPolicyType(new \optsoapsdk\StructType\GetPolicyType()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \optsoapsdk\ServiceType\Update($options);
/**
 * Sample call for UpdateAgent operation/method
 */
if ($update->UpdateAgent(new \optsoapsdk\StructType\UpdateAgent()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAgentLevelUpline operation/method
 */
if ($update->UpdateAgentLevelUpline(new \optsoapsdk\StructType\UpdateAgentLevelUpline()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateLead operation/method
 */
if ($update->UpdateLead(new \optsoapsdk\StructType\UpdateLead()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \optsoapsdk\ServiceType\Set($options);
/**
 * Sample call for SetToInactive operation/method
 */
if ($set->SetToInactive(new \optsoapsdk\StructType\SetToInactive()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \optsoapsdk\ServiceType\Change($options);
/**
 * Sample call for ChangeStatusWithSchedule operation/method
 */
if ($change->ChangeStatusWithSchedule(new \optsoapsdk\StructType\ChangeStatusWithSchedule()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeStatusWithNote operation/method
 */
if ($change->ChangeStatusWithNote(new \optsoapsdk\StructType\ChangeStatusWithNote()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Application ServiceType
 */
$application = new \optsoapsdk\ServiceType\Application($options);
/**
 * Sample call for ApplicationPopUps operation/method
 */
if ($application->ApplicationPopUps(new \optsoapsdk\StructType\ApplicationPopUps()) !== false) {
    print_r($application->getResult());
} else {
    print_r($application->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \optsoapsdk\ServiceType\Add($options);
/**
 * Sample call for AddDXIALead operation/method
 */
if ($add->AddDXIALead(new \optsoapsdk\StructType\AddDXIALead()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
