<?php

namespace optsoapsdk\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAgentDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetAgentDetail $parameters
     * @return \optsoapsdk\StructType\GetAgentDetailResponse|bool
     */
    public function GetAgentDetail(\optsoapsdk\StructType\GetAgentDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentLeads
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetAgentLeads $parameters
     * @return \optsoapsdk\StructType\GetAgentLeadsResponse|bool
     */
    public function GetAgentLeads(\optsoapsdk\StructType\GetAgentLeads $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentLeads($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLeadDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetLeadDetail $parameters
     * @return \optsoapsdk\StructType\GetLeadDetailResponse|bool
     */
    public function GetLeadDetail(\optsoapsdk\StructType\GetLeadDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLeadDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentLeadsSinceDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetAgentLeadsSinceDate $parameters
     * @return \optsoapsdk\StructType\GetAgentLeadsSinceDateResponse|bool
     */
    public function GetAgentLeadsSinceDate(\optsoapsdk\StructType\GetAgentLeadsSinceDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentLeadsSinceDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentApplicationsSinceDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetAgentApplicationsSinceDate $parameters
     * @return \optsoapsdk\StructType\GetAgentApplicationsSinceDateResponse|bool
     */
    public function GetAgentApplicationsSinceDate(\optsoapsdk\StructType\GetAgentApplicationsSinceDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentApplicationsSinceDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetApplication $parameters
     * @return \optsoapsdk\StructType\GetApplicationResponse|bool
     */
    public function GetApplication(\optsoapsdk\StructType\GetApplication $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplication($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetApplicationsCount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetApplicationsCount $parameters
     * @return \optsoapsdk\StructType\GetApplicationsCountResponse|bool
     */
    public function GetApplicationsCount(\optsoapsdk\StructType\GetApplicationsCount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetApplicationsCount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPolicyType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetPolicyType $parameters
     * @return \optsoapsdk\StructType\GetPolicyTypeResponse|bool
     */
    public function GetPolicyType(\optsoapsdk\StructType\GetPolicyType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPolicyType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \optsoapsdk\StructType\GetAgentApplicationsSinceDateResponse|\optsoapsdk\StructType\GetAgentDetailResponse|\optsoapsdk\StructType\GetAgentLeadsResponse|\optsoapsdk\StructType\GetAgentLeadsSinceDateResponse|\optsoapsdk\StructType\GetApplicationResponse|\optsoapsdk\StructType\GetApplicationsCountResponse|\optsoapsdk\StructType\GetLeadDetailResponse|\optsoapsdk\StructType\GetPolicyTypeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
