<?php

namespace optsoapsdk\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAgentLeads StructType
 * @subpackage Structs
 */
class GetAgentLeads extends AbstractStructBase
{
    /**
     * The AgentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentID;
    /**
     * The AccountType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountType;
    /**
     * The LeadLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LeadLevel;
    /**
     * Constructor method for GetAgentLeads
     * @uses GetAgentLeads::setAgentID()
     * @uses GetAgentLeads::setAccountType()
     * @uses GetAgentLeads::setLeadLevel()
     * @param string $agentID
     * @param string $accountType
     * @param string $leadLevel
     */
    public function __construct($agentID = null, $accountType = null, $leadLevel = null)
    {
        $this
            ->setAgentID($agentID)
            ->setAccountType($accountType)
            ->setLeadLevel($leadLevel);
    }
    /**
     * Get AgentID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentID()
    {
        return isset($this->AgentID) ? $this->AgentID : null;
    }
    /**
     * Set AgentID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentID
     * @return \optsoapsdk\StructType\GetAgentLeads
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentID, true), gettype($agentID)), __LINE__);
        }
        if (is_null($agentID) || (is_array($agentID) && empty($agentID))) {
            unset($this->AgentID);
        } else {
            $this->AgentID = $agentID;
        }
        return $this;
    }
    /**
     * Get AccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountType()
    {
        return isset($this->AccountType) ? $this->AccountType : null;
    }
    /**
     * Set AccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountType
     * @return \optsoapsdk\StructType\GetAgentLeads
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountType, true), gettype($accountType)), __LINE__);
        }
        if (is_null($accountType) || (is_array($accountType) && empty($accountType))) {
            unset($this->AccountType);
        } else {
            $this->AccountType = $accountType;
        }
        return $this;
    }
    /**
     * Get LeadLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeadLevel()
    {
        return isset($this->LeadLevel) ? $this->LeadLevel : null;
    }
    /**
     * Set LeadLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leadLevel
     * @return \optsoapsdk\StructType\GetAgentLeads
     */
    public function setLeadLevel($leadLevel = null)
    {
        // validation for constraint: string
        if (!is_null($leadLevel) && !is_string($leadLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leadLevel, true), gettype($leadLevel)), __LINE__);
        }
        if (is_null($leadLevel) || (is_array($leadLevel) && empty($leadLevel))) {
            unset($this->LeadLevel);
        } else {
            $this->LeadLevel = $leadLevel;
        }
        return $this;
    }
}
