<?php

namespace optsoapsdk\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAgentDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetAgentDetail $parameters
     * @return \optsoapsdk\StructType\GetAgentDetailResponse|bool
     */
    public function GetAgentDetail(\optsoapsdk\StructType\GetAgentDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAgentLeads
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetAgentLeads $parameters
     * @return \optsoapsdk\StructType\GetAgentLeadsResponse|bool
     */
    public function GetAgentLeads(\optsoapsdk\StructType\GetAgentLeads $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAgentLeads($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLeadDetail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \optsoapsdk\StructType\GetLeadDetail $parameters
     * @return \optsoapsdk\StructType\GetLeadDetailResponse|bool
     */
    public function GetLeadDetail(\optsoapsdk\StructType\GetLeadDetail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLeadDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \optsoapsdk\StructType\GetAgentDetailResponse|\optsoapsdk\StructType\GetAgentLeadsResponse|\optsoapsdk\StructType\GetLeadDetailResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
